package com.aliyun.aliyunfaceDemo;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import com.alipay.face.api.ZIMCallback;
import com.alipay.face.api.ZIMFacade;
import com.alipay.face.api.ZIMFacadeBuilder;
import com.alipay.face.api.ZIMResponse;

public class MainActivity extends AppCompatActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        ZIMFacade.install(this);

        Button btnStart = findViewById(R.id.btn_start_verify);
        if(null != btnStart){
            btnStart.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String certifyId = "请替换成自己申请的certifyid";
                    ZIMFacade zimFacade = ZIMFacadeBuilder.create(MainActivity.this);
                    zimFacade.verify(certifyId, true, new ZIMCallback() {
                        @Override
                        public boolean response(ZIMResponse response) {
                            if (null != response && 1000 == response.code) {
                                // 认证成功
                                Toast.makeText(getApplicationContext(),
                                        "认证成功\n" +
                                                "code: " + response.code + "\n" +
                                                "reason: " + response.reason,
                                        Toast.LENGTH_LONG).show();
                            } else {
                                // 认证失败
                                Toast.makeText(getApplicationContext(),
                                        "认证失败\n" +
                                                "code: " + response.code + "\n" +
                                                "reason: " + response.reason,
                                        Toast.LENGTH_LONG).show();
                            }

                            return true;
                        }
                    });
                }
            });
        }
    }
}
