/*
Title: 阿里云金融级企业版实人认证
Description: 阿里云金融级企业版实人认证
*/

<p style="color: #ccc; margin-bottom: 30px;">来自于：阿里云<a style="background-color: #95ba20; color:#fff; padding:4px 8px;border-radius:5px;margin-left:30px; margin-bottom:0px; font-size:12px;text-decoration:none;" target="_blank" href="//www.apicloud.com/mod_detail/aliyunFaceVerifyModule">立即使用</a></p>

[getMetaInfo](#a1)

[verify](#a2)

</div>

# **概述**

**阿里云金融级实人认证企业版简介**

金融级实人认证基于蚂蚁金服业内独有的人脸多因子认证技术，以及阿里经济体权威数据源，快速对自然人真实身份进行校验，安全水平已达金融级要求。

与其他实人认证服务相比，本产品使用流程中甚至不需要用户做动作就能快速得出认证结果，速度快、体验好、通过率高，符合金融监管要求。

**阿里云金融级企业版实人认证模块概述**

本模块封装了阿里云金融级实人认证企业版App SDK。

**模块使用攻略**

使用之前准备

* 阿里云官网开通产品账户，具体参见[阿里云金融云实人认证接入文档](https://help.aliyun.com/product/99161.html?spm=a2c4g.11186623.6.540.74765955wO9HbC)
* 参考App接入开发文档

## **模块接口**

<div id="a1"></div>

# **getMetaInfo**

获取服务端初始化需要的metaInfo参数

getMetaInfo(callback(ret, err))

## callback(ret, err)

ret：

- 类型：String 对象
- 内部字段：

```js
“apdidToken:\"\"......”
```
err：

- 类型：JSON 对象
- 内部字段：

```js
{
    code: 0     //数字类型；
                //错误码：
                //-1（未知错误），
                //0（成功）
}
```
## 示例代码

```js
var aliyunFace = api.require('aliyunFaceVerifyModule');
aliyunFace.getMetaInfo(function(ret, err) {
    alert(ret);
});
```

## 可用性

iOS系统，Android系统

可提供的1.0.0及更高版本

<div id="a2"></div>

# **verify**

分享文本内容

verify({params}, callback(ret, err))

## params

certifyId：

- 类型：字符串
- 描述：（必填）参见阿里云接入文档，从服务端初始化接口中获取。

ext_params_key_use_video：

- 类型：字符串
- 描述：（可选项）是否需要返回视频留证
- 默认值："false"
- 取值范围：
    * "false"
    * "True"

ext_params_key_ocr_bottom_button_color：

- 类型：字符串
- 描述：（可选项）OCR功能底部按钮颜色定制 

ext_params_key_face_progress_color：

- 类型：字符串
- 描述：（可选项）实人认证进度条颜色定制 

## callback(ret, err)

ret：

- 类型：JSON 对象
- 内部字段：

```js
{
    status: true   //布尔型；true||false
}
```

err：

- 类型：JSON 对象
- 内部字段：

```js
{
    code: 0     //数字类型；
                //错误码：
                //1000（刷脸成功）
                //1001（系统错误）
                //1003（验证中断	）
                //2002（网络错误）
                //2003（客户端设备时间错误）
                //2006（刷脸失败）
  reson: ""
  videoFilePath: ""
}
```

## 示例代码

```js
var aliyunFace = api.require('aliyunFaceVerifyModule');
aliyunFace.verify({
    certifyId: '1adffa'
}, function(ret, err) {
    if (ret.code == 1000) {
        alert('认证成功');
    } else {
        alert(err.code);
    }
});
```

## 可用性

iOS系统，Android系统

可提供的1.0.0及更高版本

<div id="a3"></div>
