/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.gateway.facade.util;

import com.alibaba.fastjson.JSON;
import com.alipay.gateway.facade.model.AuthRequest;
import com.alipay.gateway.facade.model.AuthResponse;
import com.alipay.gateway.facade.model.ByteAuthResponse;
import com.alipay.gateway.facade.model.ObjectAuthResponse;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUtil.class);

    public static AuthResponse buildAuthRes(AuthRequest request) {
        String oldVersion = request.getContext().get("oldVersion");
        AuthResponse response = StringUtils.equalsIgnoreCase((String)"true", (String)oldVersion) ? new ByteAuthResponse() : new ObjectAuthResponse();
        String headerKey = request.getContext().get("headerKey");
        String path = request.getContext().get("x-mosn-path");
        String method = request.getContext().get("x-mosn-method");
        String bodyKey = request.getContext().get("bodyKey");
        String queryKey = request.getContext().get("queryKey");
        LOGGER.info("headerKey:" + headerKey + ",bodyKey:" + bodyKey + ",queryKey:" + queryKey + ",path:" + path + ",method:" + method);
        if ("h".equalsIgnoreCase(headerKey)) {
            response.setSuccess(true);
            HashMap<String, String> principal = new HashMap<String, String>();
            principal.put("param-to-server", "abc");
            principal.put("userName", "user name is tom aaa");
            response.setPrincipal(principal);
            return response;
        }
        response.setSuccess(false);
        HashMap<String, String> failResponseHeader = new HashMap<String, String>();
        queryKey = request.getContext().get("queryKey");
        if ("q".equalsIgnoreCase(queryKey)) {
            failResponseHeader.put("header-to-client", "query");
        } else {
            failResponseHeader.put("header-to-client", "no-query");
        }
        response.setFailResponseHeader(failResponseHeader);
        HashMap<String, String> failResponseBody = new HashMap<String, String>();
        String context = JSON.toJSONString(request.getContext());
        failResponseBody.put("test", context);
        response.setFailResponse(failResponseBody);
        response.setFailResponseStatus(401);
        LOGGER.info("buildAuthRes|response|{}|{}", (Object)(response instanceof ByteAuthResponse), (Object)JSON.toJSONString((Object)response));
        return response;
    }

    public static AuthResponse buildAuthRes1(AuthRequest request) {
        String oldVersion = request.getContext().get("oldVersion");
        AuthResponse response = StringUtils.equalsIgnoreCase((String)"true", (String)oldVersion) ? new ByteAuthResponse() : new ObjectAuthResponse();
        String headerKey = request.getContext().get("headerKey");
        String bodyKey = request.getContext().get("body.bodyKey");
        String queryKey = request.getContext().get("queryKey");
        String cookieKey = request.getContext().get("cookieKey");
        if ("test".equalsIgnoreCase(headerKey) && "cookie".equalsIgnoreCase(cookieKey)) {
            response.setSuccess(true);
            HashMap<String, String> principal = new HashMap<String, String>();
            principal.put("param-to-server", "buildAuthRes1");
            response.setPrincipal(principal);
            return response;
        }
        response.setSuccess(false);
        HashMap<String, String> failResponseHeader = new HashMap<String, String>();
        if ("q".equalsIgnoreCase(queryKey)) {
            failResponseHeader.put("header-to-client", headerKey);
            failResponseHeader.put("query-to-client", queryKey);
            failResponseHeader.put("cookie-to-client", cookieKey);
        } else {
            failResponseHeader.put("header-to-client", "no-header");
            failResponseHeader.put("query-to-client", "no-query");
            failResponseHeader.put("cookie-to-client", "no-cookie");
        }
        response.setFailResponseHeader(failResponseHeader);
        HashMap<String, String> failResponseBody = new HashMap<String, String>();
        String context = JSON.toJSONString(request.getContext());
        if ("bk".equalsIgnoreCase(bodyKey)) {
            failResponseBody.put("body-to-client", "bk");
        } else {
            failResponseBody.put("body-to-client", "no-bk");
        }
        failResponseBody.put("context", context);
        failResponseBody.put("body", JSON.toJSONString((Object)bodyKey));
        response.setFailResponse(failResponseBody);
        response.setFailResponseStatus(500);
        return response;
    }
}

