/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.gateway.common;

import com.alipay.gateway.common.CustomApiRestSignFilter;
import com.alipay.sofa.gateway.api.domain.ApiSecretKey;
import com.alipay.sofa.gateway.api.filter.http.ApiServletSignFilter;
import com.alipay.sofa.rpc.config.JAXRSProviderManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Config {
    @Bean
    public FilterRegistrationBean filterRegistrationBean(@Value(value="${pub.app.accessKey}") String keyId, @Value(value="${pub.app.secretKey}") String secretKey) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.apiServletSignFilter(keyId, secretKey));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("apiServletSignFilter");
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    public ApiServletSignFilter apiServletSignFilter(@Value(value="${pub.app.accessKey}") String keyId, @Value(value="${pub.app.secretKey}") String secretKey) {
        ApiSecretKey apiSecretKey = new ApiSecretKey(keyId, secretKey);
        ApiServletSignFilter filter = new ApiServletSignFilter();
        ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
        secretKeys.add(apiSecretKey);
        filter.setApiSecretKeys(secretKeys);
        filter.setCheckSign(Boolean.valueOf(true));
        filter.setSignUriRegex("/springmvc/test/sign/.*");
        return filter;
    }

    @Bean
    public CustomApiRestSignFilter apiRestSignFilter(@Value(value="${pub.app.rest.accessKey}") String keyId, @Value(value="${pub.app.rest.secretKey}") String secretKey) {
        ApiSecretKey apiSecretKey = new ApiSecretKey(keyId, secretKey);
        ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
        secretKeys.add(apiSecretKey);
        CustomApiRestSignFilter filter = new CustomApiRestSignFilter();
        filter.setApiSecretKeys(secretKeys);
        filter.setCheckSign(Boolean.valueOf(true));
        ArrayList urlTemplates = Lists.newArrayList();
        urlTemplates.add("/v2/.*");
        filter.setUriTemplates((List)urlTemplates);
        JAXRSProviderManager.registerCustomProviderInstance((Object)filter);
        return filter;
    }
}

