/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.gateway.controller.others;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.gateway.vo.GatewayVO;
import com.alipay.sofa.gateway.api.client.ApiClient;
import com.alipay.sofa.gateway.api.client.DefaultApiClient;
import com.alipay.sofa.gateway.api.client.ResponseParser;
import com.alipay.sofa.gateway.api.domain.ApiSecretKey;
import com.alipay.sofa.gateway.api.domain.request.ApiRequest;
import com.alipay.sofa.gateway.api.domain.request.GwSdkApiRequest;
import com.alipay.sofa.gateway.api.domain.response.ApiResponse;
import com.alipay.sofa.gateway.api.exception.ApiException;
import com.alipay.sofa.gateway.api.internal.parser.json.ObjectStringParser;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rpc"})
public class GatewayRpcController {
    private ApiClient apiClient;

    @ResponseBody
    @RequestMapping(value={"/gateway"}, method={RequestMethod.GET})
    public String gateway(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty((String)host)) {
            return "x-gateway-host \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty((String)gatewayUrl)) {
            return "gatewayUrl \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String bodyParams = gatewayVO.getBodyParams();
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("GET");
        request.getHeaderParams().put("x-gateway-host", host);
        request.setBody((Object)bodyParams);
        if (StringUtils.isNotBlank((String)bodyParams)) {
            if (bodyParams.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray((String)bodyParams);
                request.setBody((Object)jsonArray);
            } else if (bodyParams.startsWith("{")) {
                JSONObject jsonObject = JSONObject.parseObject((String)bodyParams);
                request.setBody((Object)jsonObject);
            }
        } else {
            request.setBody(null);
        }
        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
            secretKeys.add(apiSecretKey);
            this.apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient)this.apiClient).setNeedDetailResponse(true);
            response = this.apiClient.execute((ApiRequest)request, (ResponseParser)new ObjectStringParser(request.getResponseClass()));
        }
        catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString((Object)responseBody);
    }

    @ResponseBody
    @RequestMapping(value={"/gateway"}, method={RequestMethod.POST})
    public String gatewayPost(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty((String)host)) {
            return "x-gateway-host \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty((String)gatewayUrl)) {
            return "gatewayUrl \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String bodyParams = gatewayVO.getBodyParams();
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("POST");
        request.getHeaderParams().put("x-gateway-host", host);
        request.setBody((Object)bodyParams);
        if (StringUtils.isNotBlank((String)bodyParams)) {
            if (bodyParams.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray((String)bodyParams);
                request.setBody((Object)jsonArray);
            } else if (bodyParams.startsWith("{")) {
                JSONObject jsonObject = JSONObject.parseObject((String)bodyParams);
                request.setBody((Object)jsonObject);
            }
        } else {
            request.setBody(null);
        }
        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
            secretKeys.add(apiSecretKey);
            this.apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient)this.apiClient).setNeedDetailResponse(true);
            response = this.apiClient.execute((ApiRequest)request, (ResponseParser)new ObjectStringParser(request.getResponseClass()));
        }
        catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString((Object)responseBody);
    }

    @ResponseBody
    @RequestMapping(value={"/gateway"}, method={RequestMethod.PUT})
    public String gatewayPut(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty((String)host)) {
            return "x-gateway-host \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty((String)gatewayUrl)) {
            return "gatewayUrl \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String bodyParams = gatewayVO.getBodyParams();
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("PUT");
        request.getHeaderParams().put("x-gateway-host", host);
        request.setBody((Object)bodyParams);
        if (StringUtils.isNotBlank((String)bodyParams)) {
            if (bodyParams.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray((String)bodyParams);
                request.setBody((Object)jsonArray);
            } else if (bodyParams.startsWith("{")) {
                JSONObject jsonObject = JSONObject.parseObject((String)bodyParams);
                request.setBody((Object)jsonObject);
            }
        } else {
            request.setBody(null);
        }
        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
            secretKeys.add(apiSecretKey);
            this.apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient)this.apiClient).setNeedDetailResponse(true);
            response = this.apiClient.execute((ApiRequest)request, (ResponseParser)new ObjectStringParser(request.getResponseClass()));
        }
        catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString((Object)responseBody);
    }

    @ResponseBody
    @RequestMapping(value={"/gateway"}, method={RequestMethod.DELETE})
    public String gatewayDelete(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty((String)host)) {
            return "x-gateway-host \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty((String)gatewayUrl)) {
            return "gatewayUrl \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String bodyParams = gatewayVO.getBodyParams();
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("DELETE");
        request.getHeaderParams().put("x-gateway-host", host);
        request.setBody((Object)bodyParams);
        if (StringUtils.isNotBlank((String)bodyParams)) {
            if (bodyParams.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray((String)bodyParams);
                request.setBody((Object)jsonArray);
            } else if (bodyParams.startsWith("{")) {
                JSONObject jsonObject = JSONObject.parseObject((String)bodyParams);
                request.setBody((Object)jsonObject);
            }
        } else {
            request.setBody(null);
        }
        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
            secretKeys.add(apiSecretKey);
            this.apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient)this.apiClient).setNeedDetailResponse(true);
            response = this.apiClient.execute((ApiRequest)request, (ResponseParser)new ObjectStringParser(request.getResponseClass()));
        }
        catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString((Object)responseBody);
    }
}

