/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.gateway.common;

import com.alipay.sofa.gateway.api.domain.ApiSecretKey;
import com.alipay.sofa.gateway.api.filter.jax.NeedSign;
import com.alipay.sofa.gateway.api.internal.util.ApiLogger;
import com.alipay.sofa.gateway.api.internal.util.StringUtils;
import com.alipay.sofa.gateway.api.internal.util.io.IOUtils;
import com.alipay.sofa.gateway.api.internal.util.sign.jax.JaxSignUtil;
import com.alipay.sofa.gateway.api.internal.util.sign.jax.JaxUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.collections.CollectionUtils;

@NeedSign
@Provider
@Priority(value=5000)
@PreMatching
public class CustomApiRestSignFilter
implements WriterInterceptor,
ContainerResponseFilter,
ContainerRequestFilter {
    private static ThreadLocal<ContainerResponseContext> containerResponseContext = new ThreadLocal();
    private static ThreadLocal<ContainerRequestContext> containerRequestContext = new ThreadLocal();
    private static ThreadLocal<ApiSecretKey> mathecdApiSecretKey = new ThreadLocal();
    private Boolean checkSign;
    private List<ApiSecretKey> apiSecretKeys;
    private List<String> uriTemplates;

    public static ContainerRequestContext getContainerRequestContext() {
        return containerRequestContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        OutputStream outputStream = context.getOutputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        context.setOutputStream((OutputStream)byteArrayOutputStream);
        try {
            context.proceed();
        }
        finally {
            byte[] bytes = byteArrayOutputStream.toByteArray();
            try {
                List<ApiSecretKey> keys;
                if (null == mathecdApiSecretKey.get()) {
                    keys = this.apiSecretKeys;
                } else {
                    keys = new ArrayList<ApiSecretKey>();
                    keys.add(mathecdApiSecretKey.get());
                }
                JaxSignUtil.sign((ContainerResponseContext)containerResponseContext.get(), (byte[])bytes, keys);
            }
            catch (Exception ex) {
                ApiLogger.error((String)("SOFA Gateway \u7b7e\u540d\u8fc7\u6ee4\u5668-\u7b7e\u540d\u751f\u6210\u5f02\u5e38, " + this.buildRequestLog(containerRequestContext.get())), (Throwable)ex);
                throw new RuntimeException(ex);
            }
            outputStream.write(bytes);
            ApiLogger.info((String)this.buildResponseLog(containerRequestContext.get(), containerResponseContext.get()));
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        List<ApiSecretKey> keys;
        if (null == mathecdApiSecretKey.get()) {
            keys = this.apiSecretKeys;
        } else {
            keys = new ArrayList<ApiSecretKey>();
            keys.add(mathecdApiSecretKey.get());
        }
        JaxSignUtil.sign((ContainerResponseContext)responseContext, null, keys);
        containerResponseContext.set(responseContext);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        containerRequestContext.set(requestContext);
        if (null == this.checkSign) {
            String flag = System.getProperty("com.alipay.sofagw.checkSign");
            this.checkSign = "true".equalsIgnoreCase(flag);
        }
        if (!this.checkSign.booleanValue()) {
            return;
        }
        String uri = requestContext.getUriInfo().getPath();
        if (!this.matchUri(uri)) {
            return;
        }
        ApiLogger.info((String)this.buildRequestLog(requestContext));
        InputStream inputStream = requestContext.getEntityStream();
        byte[] bytes = null;
        if (null != inputStream) {
            bytes = IOUtils.toByteArray((InputStream)inputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            requestContext.setEntityStream((InputStream)byteArrayInputStream);
        }
        try {
            ApiSecretKey apiSecretKey = JaxSignUtil.checkSign((ContainerRequestContext)requestContext, (byte[])bytes, this.apiSecretKeys);
            mathecdApiSecretKey.set(apiSecretKey);
        }
        catch (Exception ex) {
            ApiLogger.error((String)("SOFA Gateway \u7b7e\u540d\u8fc7\u6ee4\u5668-\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38, " + this.buildRequestLog(requestContext)), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private boolean matchUri(String uri) {
        if (StringUtils.isEmpty((String)uri)) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.uriTemplates)) {
            return true;
        }
        boolean matched = false;
        if (CollectionUtils.isNotEmpty(this.uriTemplates)) {
            for (String uriTemplate : this.uriTemplates) {
                if (!uri.matches(uriTemplate)) continue;
                matched = true;
                break;
            }
        }
        return matched;
    }

    public void setApiSecretKeys(List<ApiSecretKey> apiSecretKeys) {
        this.apiSecretKeys = apiSecretKeys;
    }

    private String buildRequestLog(ContainerRequestContext request) {
        Map headers = JaxUtil.getHeaders((ContainerRequestContext)request);
        String uri = request.getUriInfo().getPath();
        StringBuilder sb = new StringBuilder();
        sb.append("[SOFA Gateway \u7b7e\u540d\u8fc7\u6ee4\u5668] ");
        sb.append("uri:[").append(uri).append("];");
        sb.append("request header:[").append(headers).append("];");
        return sb.toString();
    }

    private String buildResponseLog(ContainerRequestContext request, ContainerResponseContext response) {
        Map requestHeaders = JaxUtil.getHeaders((ContainerRequestContext)request);
        Map responseHeaders = JaxUtil.getHeaders((ContainerResponseContext)response);
        String uri = request.getUriInfo().getPath();
        StringBuilder sb = new StringBuilder();
        sb.append("[SOFA Gateway \u7b7e\u540d\u8fc7\u6ee4\u5668] ");
        sb.append("uri:[").append(uri).append("];");
        sb.append("request header:[").append(requestHeaders).append("];");
        sb.append("response header:[").append(responseHeaders).append("];");
        return sb.toString();
    }

    public Boolean getCheckSign() {
        return this.checkSign;
    }

    public void setCheckSign(Boolean checkSign) {
        this.checkSign = checkSign;
    }

    public void setUriTemplates(List<String> uriTemplates) {
        this.uriTemplates = uriTemplates;
    }
}

