/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.gateway.controller.others;

import com.alibaba.fastjson.JSON;
import com.alipay.gateway.vo.GatewayVO;
import com.alipay.sofa.gateway.api.client.ApiClient;
import com.alipay.sofa.gateway.api.client.DefaultApiClient;
import com.alipay.sofa.gateway.api.client.ResponseParser;
import com.alipay.sofa.gateway.api.domain.ApiSecretKey;
import com.alipay.sofa.gateway.api.domain.request.ApiRequest;
import com.alipay.sofa.gateway.api.domain.request.GwSdkApiRequest;
import com.alipay.sofa.gateway.api.domain.response.ApiResponse;
import com.alipay.sofa.gateway.api.exception.ApiException;
import com.alipay.sofa.gateway.api.internal.parser.json.ObjectStringParser;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class GatewayHttpController {
    private ApiClient apiClient;

    @ResponseBody
    @RequestMapping(value={"/gateway"}, method={RequestMethod.GET})
    public String gateway(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty((String)host)) {
            return "x-gateway-host \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty((String)gatewayUrl)) {
            return "gatewayUrl \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        String queryParams = gatewayVO.getQueryParams();
        String headerParams = gatewayVO.getHeaderParams();
        String cookieParams = gatewayVO.getCookieParams();
        HashMap map = Maps.newHashMap();
        Map queryMap = (Map)JSON.parse((String)queryParams);
        Map headerMap = (Map)JSON.parse((String)headerParams);
        Map cookieMap = (Map)JSON.parse((String)cookieParams);
        GwSdkApiRequest request = new GwSdkApiRequest();
        if (queryMap != null) {
            map.putAll(queryMap);
        }
        if (headerMap != null) {
            map.putAll(headerMap);
            request.getHeaderParams().putAll(headerMap);
        }
        if (cookieMap != null) {
            map.putAll(cookieMap);
        }
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("GET");
        request.getHeaderParams().put("x-gateway-host", host);
        request.getBizParams().putAll(map);
        request.setBody((Object)map);
        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
            secretKeys.add(apiSecretKey);
            this.apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient)this.apiClient).setNeedDetailResponse(true);
            response = this.apiClient.execute((ApiRequest)request, (ResponseParser)new ObjectStringParser(request.getResponseClass()));
        }
        catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString((Object)responseBody);
    }

    @ResponseBody
    @RequestMapping(value={"/gateway"}, method={RequestMethod.POST})
    public String gatewayPost(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty((String)host)) {
            return "x-gateway-host \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty((String)gatewayUrl)) {
            return "gatewayUrl \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        String queryParams = gatewayVO.getQueryParams();
        String headerParams = gatewayVO.getHeaderParams();
        String cookieParams = gatewayVO.getCookieParams();
        HashMap map = Maps.newHashMap();
        Map queryMap = (Map)JSON.parse((String)queryParams);
        Map headerMap = (Map)JSON.parse((String)headerParams);
        Map cookieMap = (Map)JSON.parse((String)cookieParams);
        GwSdkApiRequest request = new GwSdkApiRequest();
        if (queryMap != null) {
            map.putAll(queryMap);
        }
        if (headerMap != null) {
            map.putAll(headerMap);
            request.getHeaderParams().putAll(headerMap);
        }
        if (cookieMap != null) {
            map.putAll(cookieMap);
        }
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("POST");
        request.getHeaderParams().put("x-gateway-host", host);
        request.getBizParams().putAll(map);
        request.setBody((Object)map);
        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
            secretKeys.add(apiSecretKey);
            this.apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient)this.apiClient).setNeedDetailResponse(true);
            response = this.apiClient.execute((ApiRequest)request, (ResponseParser)new ObjectStringParser(request.getResponseClass()));
        }
        catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString((Object)responseBody);
    }

    @ResponseBody
    @RequestMapping(value={"/gateway"}, method={RequestMethod.PUT})
    public String gatewayPut(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty((String)host)) {
            return "x-gateway-host \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty((String)gatewayUrl)) {
            return "gatewayUrl \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        String queryParams = gatewayVO.getQueryParams();
        String headerParams = gatewayVO.getHeaderParams();
        String cookieParams = gatewayVO.getCookieParams();
        HashMap map = Maps.newHashMap();
        Map queryMap = (Map)JSON.parse((String)queryParams);
        Map headerMap = (Map)JSON.parse((String)headerParams);
        Map cookieMap = (Map)JSON.parse((String)cookieParams);
        GwSdkApiRequest request = new GwSdkApiRequest();
        if (queryMap != null) {
            map.putAll(queryMap);
        }
        if (headerMap != null) {
            map.putAll(headerMap);
            request.getHeaderParams().putAll(headerMap);
        }
        if (cookieMap != null) {
            map.putAll(cookieMap);
        }
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("PUT");
        request.getHeaderParams().put("x-gateway-host", host);
        request.getBizParams().putAll(map);
        request.setBody((Object)map);
        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
            secretKeys.add(apiSecretKey);
            this.apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient)this.apiClient).setNeedDetailResponse(true);
            response = this.apiClient.execute((ApiRequest)request, (ResponseParser)new ObjectStringParser(request.getResponseClass()));
        }
        catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString((Object)responseBody);
    }

    @ResponseBody
    @RequestMapping(value={"/gateway"}, method={RequestMethod.DELETE})
    public String gatewayDelete(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty((String)host)) {
            return "x-gateway-host \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty((String)gatewayUrl)) {
            return "gatewayUrl \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        String queryParams = gatewayVO.getQueryParams();
        String headerParams = gatewayVO.getHeaderParams();
        String cookieParams = gatewayVO.getCookieParams();
        HashMap map = Maps.newHashMap();
        Map queryMap = (Map)JSON.parse((String)queryParams);
        Map headerMap = (Map)JSON.parse((String)headerParams);
        Map cookieMap = (Map)JSON.parse((String)cookieParams);
        GwSdkApiRequest request = new GwSdkApiRequest();
        if (queryMap != null) {
            map.putAll(queryMap);
        }
        if (headerMap != null) {
            map.putAll(headerMap);
            request.getHeaderParams().putAll(headerMap);
        }
        if (cookieMap != null) {
            map.putAll(cookieMap);
        }
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("DELETE");
        request.getHeaderParams().put("x-gateway-host", host);
        request.getBizParams().putAll(map);
        request.setBody((Object)map);
        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            ArrayList<ApiSecretKey> secretKeys = new ArrayList<ApiSecretKey>();
            secretKeys.add(apiSecretKey);
            this.apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient)this.apiClient).setNeedDetailResponse(true);
            response = this.apiClient.execute((ApiRequest)request, (ResponseParser)new ObjectStringParser(request.getResponseClass()));
        }
        catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString((Object)responseBody);
    }
}

