/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.gateway.sofarpc;

import com.alipay.gateway.facade.model.Account;
import com.alipay.gateway.facade.model.AccountQueryResult;
import com.alipay.gateway.facade.model.AccountSer;
import com.alipay.gateway.facade.rpc.GatewayRpcDeserializeService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
@SofaService(bindings={@SofaServiceBinding(bindingType="bolt")}, uniqueId="rpc-test-1112")
public class GatewayRpcDeserializeServiceImpl
implements GatewayRpcDeserializeService {
    public AccountQueryResult queryAccountBalance(String accountNo) {
        AccountQueryResult accountQueryResult = new AccountQueryResult();
        Account account = new Account(accountNo, new BigDecimal(11111111), new BigDecimal(22222222), new BigDecimal(33333333));
        accountQueryResult.setSuccess(true);
        accountQueryResult.setAccount(account);
        accountQueryResult.setMsgCode("200");
        accountQueryResult.setMsgText("success");
        return accountQueryResult;
    }

    public Map<String, String> hello() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("targetIp", GatewayRpcDeserializeServiceImpl.getLocalIpAddress());
        return map;
    }

    public Account queryAccount(String accountNo) {
        Account account = new Account(accountNo, new BigDecimal(11111111), new BigDecimal(22222222), new BigDecimal(33333333));
        return account;
    }

    public BigDecimal queryAccountBalance2(Account account) {
        return new BigDecimal(account.getAccountNo());
    }

    public AccountSer queryAccountSer(String accountNo) {
        return new AccountSer(accountNo, new BigDecimal(11111111), new BigDecimal(22222222), new BigDecimal(33333333));
    }

    public BigDecimal queryAccountSerBalance2(AccountSer accountSer) {
        return new BigDecimal(accountSer.getAccountNo());
    }

    public static String getLocalIpAddress() {
        try {
            long start = System.currentTimeMillis();
            InetAddress localHost = InetAddress.getLocalHost();
            long end = System.currentTimeMillis();
            System.out.println("end-start = " + (end - start));
            String ip = localHost.getHostAddress();
            if (StringUtils.isNotEmpty((String)ip) && !StringUtils.equalsIgnoreCase((String)ip, (String)"127.0.0.1")) {
                return ip;
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("get localhost information error", e);
        }
        throw new RuntimeException("local ip is empty");
    }
}

