/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.gateway.sofarpc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.gateway.facade.rpc.TestTracerRpcService;
import com.alipay.sofa.gateway.api.client.DefaultApiClient;
import com.alipay.sofa.gateway.api.domain.ApiSecretKey;
import com.alipay.sofa.gateway.api.domain.request.ApiRequest;
import com.alipay.sofa.gateway.api.domain.request.GwSdkApiRequest;
import com.alipay.sofa.gateway.api.domain.response.ApiResponse;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@SofaService(bindings={@SofaServiceBinding(bindingType="bolt")}, uniqueId="rpc-test-1112")
public class TestTracerRpcServiceImpl
implements TestTracerRpcService {
    public JSONObject testTracer(JSONObject param) {
        ArrayList secretKeys = Lists.newArrayList();
        JSONArray secretKeyArray = param.getJSONArray("secretKeys");
        for (Object o : secretKeyArray) {
            secretKeys.add(JSON.parseObject((String)JSON.toJSONString(o), ApiSecretKey.class));
        }
        String gatewayUrl = param.getString("gatewayUrl");
        String method = param.getString("method");
        String path = param.getString("path");
        String gatewayHost = param.getString("gatewayHost");
        DefaultApiClient apiClient = new DefaultApiClient(gatewayUrl, (List)secretKeys);
        apiClient.setNeedDetailResponse(true);
        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setRequestType(method);
        request.setPath(path);
        request.setClientCheckSign(false);
        request.getHeaderParams().put("x-gateway-host", gatewayHost);
        String traceId = this.getTracerId();
        request.getHeaderParams().put("rpc_trace_context.sofaTraceId", traceId);
        request.setBody((Object)123);
        ApiResponse response = apiClient.execute((ApiRequest)request);
        return JSON.parseObject((String)JSON.toJSONString((Object)response));
    }

    private String getTracerId() {
        SofaTracerSpan span = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        if (span == null) {
            return "";
        }
        return span.getSofaTracerSpanContext().getTraceId();
    }
}

