/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.facade.rest.nosign;

import com.alipay.gateway.facade.model.*;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;

/**
 * @author wb-hzb742209
 * @date 2020年12月2日 下午6:59:04
 */
@Path("rest")
public interface ApiflowRestPostService {
    @POST
    @Path("getTourist")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Tourist getTourist(String idCard);

    @POST
    @Path("getPoint")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Point jsonParam(Point point);

    @POST
    @Path("getShip")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Ship jsonParam(Ship ship);

    @POST
    @Path("noParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String noParam();

    @POST
    @Path("sampleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String sampleParam(String param);

    @POST
    @Path("param/{uid}")
    String uidParam(@PathParam("uid") String uid);

    @POST
    @Path("moreParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String moreParam(@CookieParam("param") String param, @HeaderParam("param1") String param1, String param2);

    @POST
    @Path("headerParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> headerParam(HttpServletRequest request);

    @POST
    @Path("jsonParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, Object> jsonParam(@RequestBody User user);

    @POST
    @Path("formParam")
    @Produces(MediaType.APPLICATION_FORM_URLENCODED)
    @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
    Map<String, Object> formParam(@FormParam("name") String name, @FormParam("age") String age);

    @POST
    @Path("timeout")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String timeout(String sleepTime);

    @POST
    @Path("exception")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    void exception() throws Exception;

    @POST
    @Path("auth")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    AuthResponse auth(AuthRequest authRequest);

    @POST
    @Path("hello")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> hello();

    @POST
    @Path("objectNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectNoParam();

    @POST
    @Path("objectSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectSimpleParam(User user);

    @POST
    @Path("mapNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> mapNoParam();

    @POST
    @Path("mapSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, User> mapSimpleParam(Map<String, User> map);

    @POST
    @Path("listNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<String> listNoParam();

    @POST
    @Path("listSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<User> listSimpleParam(List<User> list);



    @POST
    @Path("getApiParam2")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String getApiParam2(String param);

    @POST
    @Path("getApiParam3")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String getApiParam3(String param);

    @POST
    @Path("getApiParam3Sign")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String getApiParam3Sign(@HeaderParam("param") String param);

    @POST
    @Path("weightRouter")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String router();
}