/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.facade.rest.nosign;

import com.alipay.gateway.facade.model.AuthRequest;
import com.alipay.gateway.facade.model.AuthResponse;
import com.alipay.gateway.facade.model.User;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;

/**
 * @author wb-hzb742209
 * @date 2020年12月7日 下午8:35:04
 */
@Path("rest")
public interface SofaRestGetService {
    @GET
    @Path("noParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String noParam();

    @GET
    @Path("sampleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String sampleParam(@QueryParam("param") String param);

    @GET
    @Path("param/{uid}")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String uidParam(@PathParam("uid") String uid);

    @GET
    @Path("moreParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String moreParam(@QueryParam("param") String param, @HeaderParam("param1") String param1, @QueryParam("param2") String param2);

    @GET
    @Path("headerParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> headerParam(HttpServletRequest request);

    @GET
    @Path("jsonParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, Object> jsonParam(User user);

    @GET
    @Path("timeout")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String timeout(@QueryParam("sleepTime") String sleepTime);

    @GET
    @Path("exception")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    void exception() throws Exception;

    @GET
    @Path("auth")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    AuthResponse auth(AuthRequest authRequest);

    @GET
    @Path("hello")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> hello();

    @GET
    @Path("objectNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectNoParam();

    @GET
    @Path("objectSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectSimpleParam(User user);

    @GET
    @Path("mapNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> mapNoParam();

    @GET
    @Path("mapSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, User> mapSimpleParam(Map<String, User> map);

    @GET
    @Path("listNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<String> listNoParam();

    @GET
    @Path("listSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<User> listSimpleParam(List<User> list);

    @GET
    @Path("weightRouter")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String router();
}