/**
 * Alipay.com Inc. Copyright (c) 2004-2021 All Rights Reserved.
 */
package com.alipay.immune.model.result;


import java.io.Serializable;

/**
 * 结果基类
 *
 * @author llhuan.lh
 * @version $Id: Result.java, v 0.1 2021年03月29日 5:09 PM llhuan.lh Exp $
 */
public class Result<T> implements Serializable {

    private static final long serialVersionUID = 827138473981294177L;

    /**
     * 当前请求是否成功
     */
    private Boolean success = false;

    /**
     * 请求返回的结果描述
     */
    private String msg;

    /**
     * 返回的数据
     * data 使用 com.alipay.immune.model.result.ImmCheckResultData
     * {@linkplain ImmCheckResultData}
     */
    private T data;

    /**
     * 错误码需要定义constant类
     */
    private String errorCode = "SUCCESS";

    /**
     * default Constructor
     */
    public Result() {
    }

    /**
     * Constructor 1.
     * @param success
     */
    public Result(Boolean success) {
        this.success = success;
    }

    /**
     * Constructor 2
     * @param data
     */
    public Result(T data){
        this.data = (T) data;
        this.success = true;
    }

    /**
     * Constructor 3.
     * @param success
     * @param msg
     * @param errorCode
     */
    public Result(Boolean success, String msg, String errorCode) {
        this.success = success;
        this.msg = msg;
        this.errorCode = errorCode;
    }

    /**
     * Getter method for property <tt>success</tt>.
     *
     * @return property value of success
     */
    public Boolean getSuccess() {
        return success;
    }

    /**
     * Setter method for property <tt>success</tt>.
     *
     * @param success value to be assigned to property success
     */
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    /**
     * Getter method for property <tt>msg</tt>.
     *
     * @return property value of msg
     */
    public String getMsg() {
        return msg;
    }

    /**
     * Setter method for property <tt>msg</tt>.
     *
     * @param msg value to be assigned to property msg
     */
    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * Getter method for property <tt>data</tt>.
     *
     * @return property value of data
     */
    public T getData() {
        return data;
    }

    /**
     * Setter method for property <tt>data</tt>.
     *
     * @param data value to be assigned to property data
     */
    public void setData(T data) {
        this.data = data;
    }

    /**
     * Getter method for property <tt>errorCode</tt>.
     *
     * @return property value of errorCode
     */
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * Setter method for property <tt>errorCode</tt>.
     *
     * @param errorCode value to be assigned to property errorCode
     */
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

}