package com.zjrc.common.domain;


import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;


/**
 * 平台公用报文头信息
 * @author 鲁友铭
 */
public class ControlData implements Serializable {

    private static final long serialVersionUID = 5713354867420373586L;
    /**
     * 交易机构
     */
    @NotNull
    private String transBranch;
    /**
     * 渠道号
     */
    @NotNull
    private String transMedium;
    /**
     * 渠道流水号
     */
    @NotNull
    private String transSeqNo;
    /**
     * 柜员号
     */
    private String transTeller = "";

    /**
     * 系统编号
     */
    @NotNull
    private String sysIndicator;
    /**
     * 服务ID(服务代码)
     */
    @NotNull
    private String servcId;
    /**
     * 终端设备编号
     */
    private String termId;
    /**
     * 用户ID
     */
    private String userId;

    /**
     * 服务调用时间
     */
    @NotNull
    private Date reqTime;
    /**
     * 业务跟踪号
     */
    @NotNull
    private String bizTrackNo;
    /**
     * 分页参数,本页记录数
     */
    private int pageSize;
    /**
     * 分页参数,页码,从1开始
     */
    private int pageIndex;
    /**
     * 服务调用方IP
     */
    @NotNull
    private String hostIp;
    /**
     * 交易授权是否通过标志
     */
    private String authTransSuccFlag;
    /**
     * 额度授权是否通过标志
     */
    private String authTransAmtSuccFlag;
    /**
     * 柜员流水号
     */
    private String tellerSeqNo;
    /**
     * 交易备注
     */
    private String transDesc;
    /**
     * app推送ID
     */
    private String appPushId;
    /**
     * 备用
     */
    private String servRemark;
    /**
     * 企业ID
     */
    private String corpId;
    /**
     * 企业核心内码
     */
    private String corpCoreId;
    /**
     * 企业审批标识
     */
    private String corpAuthFlag;
    /**
     * 交易授权柜员
     */
    private String authTeller;
    /**
     * 备用2
     */
    private String transRemark;

    /**
     * @return the transBranch
     */
    public String getTransBranch() {
        return transBranch;
    }

    /**
     * @param transBranch
     *            the transBranch to set
     */
    public void setTransBranch(String transBranch) {
        this.transBranch = transBranch;
    }

    /**
     * @return the transMedium
     */
    public String getTransMedium() {
        return transMedium;
    }

    /**
     * @param transMedium
     *            the transMedium to set
     */
    public void setTransMedium(String transMedium) {
        this.transMedium = transMedium;
    }

    /**
     * @return the transSeqNo
     */
    public String getTransSeqNo() {
        return transSeqNo;
    }

    /**
     * @param transSeqNo
     *            the transSeqNo to set
     */
    public void setTransSeqNo(String transSeqNo) {
        this.transSeqNo = transSeqNo;
    }

    /**
     * @return the transTeller
     */
    public String getTransTeller() {
        return transTeller;
    }

    /**
     * @param transTeller
     *            the transTeller to set
     */
    public void setTransTeller(String transTeller) {
        this.transTeller = transTeller;
    }

    /**
     * @return the sysIndicator
     */
    public String getSysIndicator() {
        return sysIndicator;
    }

    /**
     * @param sysIndicator
     *            the sysIndicator to set
     */
    public void setSysIndicator(String sysIndicator) {
        this.sysIndicator = sysIndicator;
    }

    /**
     * @return the servcId
     */
    public String getServcId() {
        return servcId;
    }

    /**
     * @param servcId
     *            the servcId to set
     */
    public void setServcId(String servcId) {
        this.servcId = servcId;
    }

    /**
     * @return the termId
     */
    public String getTermId() {
        return termId;
    }

    /**
     * @param termId
     *            the termId to set
     */
    public void setTermId(String termId) {
        this.termId = termId;
    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId;
    }

    /**
     * @param userId
     *            the userId to set
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * @return the reqTime
     */
    public Date getReqTime() {
        return reqTime;
    }

    /**
     * @param reqTime
     *            the reqTime to set
     */
    public void setReqTime(Date reqTime) {
        this.reqTime = reqTime;
    }

    /**
     * @return the bizTrackNo
     */
    public String getBizTrackNo() {
        return bizTrackNo;
    }

    /**
     * @param bizTrackNo
     *            the bizTrackNo to set
     */
    public void setBizTrackNo(String bizTrackNo) {
        this.bizTrackNo = bizTrackNo;
    }

    /**
     * @return the pageSize
     */
    public int getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize
     *            the pageSize to set
     */
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * @return the pageIndex
     */
    public int getPageIndex() {
        return pageIndex;
    }

    /**
     * @param pageIndex
     *            the pageIndex to set
     */
    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    /**
     * @return the hostIp
     */
    public String getHostIp() {
        return hostIp;
    }

    /**
     * @param hostIp
     *            the hostIp to set
     */
    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    /**
     * @return the authTransSuccFlag
     */
    public String getAuthTransSuccFlag() {
        return authTransSuccFlag;
    }

    /**
     * @param authTransSuccFlag
     *            the authTransSuccFlag to set
     */
    public void setAuthTransSuccFlag(String authTransSuccFlag) {
        this.authTransSuccFlag = authTransSuccFlag;
    }

    /**
     * @return the authTransAmtSuccFlag
     */
    public String getAuthTransAmtSuccFlag() {
        return authTransAmtSuccFlag;
    }

    /**
     * @param authTransAmtSuccFlag
     *            the authTransAmtSuccFlag to set
     */
    public void setAuthTransAmtSuccFlag(String authTransAmtSuccFlag) {
        this.authTransAmtSuccFlag = authTransAmtSuccFlag;
    }

    /**
     * @return the tellerSeqNo
     */
    public String getTellerSeqNo() {
        return tellerSeqNo;
    }

    /**
     * @param tellerSeqNo
     *            the tellerSeqNo to set
     */
    public void setTellerSeqNo(String tellerSeqNo) {
        this.tellerSeqNo = tellerSeqNo;
    }

    /**
     * @return the transDesc
     */
    public String getTransDesc() {
        return transDesc;
    }

    /**
     * @param transDesc
     *            the transDesc to set
     */
    public void setTransDesc(String transDesc) {
        this.transDesc = transDesc;
    }

    public String getAppPushId() {
        return appPushId;
    }

    public void setAppPushId(String appPushId) {
        this.appPushId = appPushId;
    }

    public String getServRemark() {
        return servRemark;
    }

    public void setServRemark(String servRemark) {
        this.servRemark = servRemark;
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getCorpCoreId() {
        return corpCoreId;
    }

    public void setCorpCoreId(String corpCoreId) {
        this.corpCoreId = corpCoreId;
    }

    public String getCorpAuthFlag() {
        return corpAuthFlag;
    }

    public void setCorpAuthFlag(String corpAuthFlag) {
        this.corpAuthFlag = corpAuthFlag;
    }

    public String getAuthTeller() {
        return authTeller;
    }

    public void setAuthTeller(String authTeller) {
        this.authTeller = authTeller;
    }

    public String getTransRemark() {
        return transRemark;
    }

    public void setTransRemark(String transRemark) {
        this.transRemark = transRemark;
    }
}

