package com.zjrc.common.domain;


import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 平台公用响应头信息
 * @author 鲁友铭
 */
public class ResponseData implements Serializable {

    private static final long serialVersionUID = -2531859447340773523L;
    /**
     * 返回状态编码
     */
    @NotNull
    private String code = "00000000";
    /**
     * 返回消息
     */
    private String message = null;
    /**
     * 幅度段IP
     */
    private String serverIp;
    /**
     * 服务返回时间
     */
    @NotNull
    private Date returnTime;
    /**
     * 服务端流水号
     */
    private String servcSeqNo;
    /**
     * 总记录数
     */
    private int recordCount;
    /**
     * 返回状态标志
     * update:  "00000" -> "S"    wyq 2022.3.4
     */
    private String type = "S";

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getServerIp() {
        return serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public Date getReturnTime() {
        return returnTime;
    }

    public void setReturnTime(Date returnTime) {
        this.returnTime = returnTime;
    }

    public String getServcSeqNo() {
        return servcSeqNo;
    }

    public void setServcSeqNo(String servcSeqNo) {
        this.servcSeqNo = servcSeqNo;
    }

    public int getRecordCount() {
        return recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
