package com.alipay.gateway.controller.externalauth;

import java.io.File;
import java.nio.charset.StandardCharsets;

import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;

import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriUtils;

/**
 * @author wb-hzb742209
 * @date 2021年2月24日 下午6:21:21
 */
@RestController
@RequestMapping("/test")
public class FormResponseController {

    /**
     * Content-Type: application/x-www-form-urlencoded
     */
    @RequestMapping(value = "/x-www-form", method = RequestMethod.POST)
    public void testXwwwForm(@FormParam("name") String name, @FormParam("age") String age,
                             HttpServletResponse response) throws Exception {
        HttpEntity httpEntity = MultipartEntityBuilder.create()
            // 表单 => （部件名称，数据，类型），要注意uri编码
            .addPart("name",
                new StringBody(UriUtils.encode(name, StandardCharsets.UTF_8),
                    ContentType.APPLICATION_FORM_URLENCODED))
            .addPart("age", new StringBody(UriUtils.encode(age, StandardCharsets.UTF_8),
                ContentType.APPLICATION_FORM_URLENCODED))
            .build();

        // 设置ContentType
        response.setContentType(httpEntity.getContentType().getValue());

        // 响应客户端
        httpEntity.writeTo(response.getOutputStream());
    }

    /**
     * Content-Type: multipart/form-data
     */
    @RequestMapping(value = "/form-data", method = RequestMethod.POST)
    public void testFormData(@FormParam("name") String name, @FormParam("age") String age,
                             HttpServletResponse response) throws Exception {
        HttpEntity httpEntity = MultipartEntityBuilder.create()
            // 表单 => （部件名称，数据，类型），要注意uri编码
            .addPart("name",
                new StringBody(UriUtils.encode(name, StandardCharsets.UTF_8),
                    ContentType.MULTIPART_FORM_DATA))
            .addPart("age", new StringBody(UriUtils.encode(age, StandardCharsets.UTF_8),
                ContentType.MULTIPART_FORM_DATA))
            .build();

        // 设置ContentType
        response.setContentType(httpEntity.getContentType().getValue());

        // 响应客户端
        httpEntity.writeTo(response.getOutputStream());
    }

    /**
     * application/json
     */
    @RequestMapping(value = "/json", method = RequestMethod.POST)
    public void testJson(HttpServletResponse response) throws Exception {

        HttpEntity httpEntity = MultipartEntityBuilder.create()
            // JSON => （部件名称，JSON，类型）
            .addPart("info", new StringBody("{\"site\": \"https://springboot.io\", \"year\": 2019}",
                ContentType.APPLICATION_JSON))
            .build();

        // 设置ContentType
        response.setContentType(httpEntity.getContentType().getValue());

        // 响应客户端
        httpEntity.writeTo(response.getOutputStream());
    }

    /**
     * image/png
     */
    @RequestMapping(value = "/image", method = RequestMethod.GET)
    public void testImage(HttpServletResponse response) throws Exception {

        HttpEntity httpEntity = MultipartEntityBuilder.create()
            // 文件 => （ 部件名称，文件，类型，文件名称）
            .addBinaryBody("logo", new File("D:\\logo.png"), ContentType.IMAGE_PNG, "logo.png")
            .build();

        // 设置ContentType
        response.setContentType(httpEntity.getContentType().getValue());

        // 响应客户端
        httpEntity.writeTo(response.getOutputStream());
    }
}
