package com.alipay.gateway.controller.http;

import com.alipay.gateway.facade.model.Point;
import com.alipay.gateway.facade.model.Ship;
import com.alipay.gateway.facade.model.Tourist;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 接口编排 http请求 controller
 */
@RestController
public class ApiflowController {


    @RequestMapping(value = "/springmvc/test/saga/getTouristHttp2Http", method = RequestMethod.POST)
    public Tourist getTouristHttp2Http(String idCard) {
        Tourist tourist = new Tourist();
        tourist.setIdCard(idCard);
        tourist.setAge(22);
        tourist.setName("小强");
        tourist.setSex("男");
        tourist.setPhones(Arrays.asList("8697852", "8697853"));

        System.out.println("###tourist=" + tourist);
        return tourist;
    }
    @RequestMapping(value = "/springmvc/test/saga/getPointHttp2Http", method = RequestMethod.POST)
    public Point getPointHttp2Http(@RequestBody Point point) { //需要入参手机号
        point.setWifeName("小丽");
        point.setCount("100");

        System.out.println("###point=" + point);
        return point;
    }
    @RequestMapping(value = "/springmvc/test/saga/getShipHttp2Http", method = RequestMethod.POST)
    public Ship getShipHttp2Http(@RequestBody Ship ship) { //需要入参wifeName
        ship.setIdCard("888");

        System.out.println("###ship=" + ship);
        return ship;
    }

    // 集群验签
    @RequestMapping(value = "/springmvc/test/sign/getTouristHttp2Http", method = RequestMethod.POST)
    public Tourist getTouristHttp2HttpAuth(String idCard) {
        Tourist tourist = new Tourist();
        tourist.setIdCard(idCard);
        tourist.setAge(22);
        tourist.setName("小强");
        tourist.setSex("男");
        tourist.setPhones(Arrays.asList("8697852", "8697853"));

        System.out.println("###tourist=" + tourist);
        return tourist;
    }
    @RequestMapping(value = "/springmvc/test/sign/getPointHttp2Http", method = RequestMethod.POST)
    public Point getPointHttp2HttpAuth(@RequestBody Point point) { //需要入参手机号
        point.setWifeName("小丽");
        point.setCount("100");

        System.out.println("###point=" + point);
        return point;
    }
    @RequestMapping(value = "/springmvc/test/sign/getShipHttp2Http", method = RequestMethod.POST)
    public Ship getShipHttp2HttpAuth(@RequestBody Ship ship) { //需要入参wifeName
        ship.setIdCard("888");

        System.out.println("###ship=" + ship);
        return ship;
    }


    // 测试cookie 和 header
    @RequestMapping(value = "/springmvc/test/noSign/httpCookieAndHeader", method = RequestMethod.POST)
    public String httpCookieAndHeader(@CookieValue("myName") String myName, @CookieValue("yourName") String yourName, @RequestHeader("param")  String aheader )   {
        System.out.println("###getApiParam1Sign: myName=" + myName + ", yourName=" + yourName + ", aheader=" + aheader);

        return myName + " & "+ yourName + " & " + aheader;
    }



}
