/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.controller.http;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.alipay.gateway.facade.model.StringInput;
import com.alipay.gateway.facade.model.StringOutput;
import com.alipay.gateway.facade.model.User;
import com.alipay.gateway.facade.rpc.GatewayRegistryPushService;


/**
 * 服务采用spring mvc 场景
 *
 * @author wb-hzb742209
 * @date 2020年11月30日 上午11:10:33
 */
@Controller
@RequestMapping(path = {"/springmvc/test/nosign", "/springmvc/test/sign"})
public class MvcServerController extends HttpBaseService {
    
    @Autowired
    GatewayRegistryPushService gatewayRegistryPushService;

    /**
     * 测试场景： 没有参数的测试
     *
     * @return
     */
    @RequestMapping(value = "/param/noParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> hello() {
        return super.hello();
    }

    /**
     * 测试场景：简单参数
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/simpleParam", method = {RequestMethod.GET, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public String simpleParam(@RequestParam("param") String param) {
        return super.simpleParam(param);
    }
    
    /**
     * 测试注册中心推送数据
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/pushData", method = {RequestMethod.GET, RequestMethod.DELETE})
    @ResponseBody
    public Boolean pushRegistryData(@RequestParam("push") String param) {
        gatewayRegistryPushService.pushData(Boolean.parseBoolean(param));
        return true;      
    }

    /**
     * 测试场景：简单参数
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/simpleParam", method = {RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public String simpleBodyParam(@RequestBody String param) {
        return super.simpleParam(param);
    }

    /**
     * 测试场景：简单参数
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/simpleParamForMap", method = {RequestMethod.GET, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> simpleParamForMap(@RequestParam("param") String param) {
        return super.simpleParamForMap(param);
    }

    /**
     * 测试场景：简单参数
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/simpleParamForMap", method = {RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public Map<String, String> simpleBodyParamForMap(@RequestBody String param) {
        return super.simpleParamForMap(param);
    }

    /**
     * 测试场景： 测试权重路由的接口
     *
     * @return
     */
    @RequestMapping(value = "/param/routerweight", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public String routerweight() {
        return super.routerweight();
    }

    /**
     * 测试场景： 测试权重路由的接口
     *
     * @return
     */
    @RequestMapping(value = "/param/routerweightRpc2Http", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, Object> routerweightRpc2Http() {
        return super.routerweightRpc2Http();
    }

    /**
     * 测试场景：简单参数
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/intParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Integer intParam(Integer param) {
        return super.intParam(param);
    }

    /**
     * 测试场景：多参数
     *
     * @return
     */
    @RequestMapping(value = "/param/multiParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> multiParam(@RequestParam("param1") String param1,
                                          @RequestParam("param2") String param2) {
        return super.multiParam(param1, param2);
    }

    /**
     * 测试场景：多参数
     *
     * @return
     */
    @RequestMapping(value = "/param/multiParamList", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> multiParamList(@RequestBody List<String> params) {
        return super.multiParamList(params);
    }

    /**
     * 测试场景：路径参数
     *
     * @param uid
     * @return
     */
    @RequestMapping(value = "/param/{uid}", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> pathParam(@PathVariable("uid") String uid) {
        return super.pathParam(uid);
    }

    /**
     * 测试场景：json参数
     *
     * @param user
     * @return
     */
    @RequestMapping(value = "/param/jsonParam", method = {RequestMethod.GET, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public User jsonParam(User user) {
        return super.jsonParam(user);
    }

    /**
     * 测试场景：json参数
     *
     * @param user
     * @return
     */
    @RequestMapping(value = "/param/jsonParam", method = {RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public User jsonBodyParam(@RequestBody User user) {
        return super.jsonParam(user);
    }

    /**
     * 场景：获取cookie|header|query 内容
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/param/withHeader", method = {RequestMethod.GET, RequestMethod.DELETE})
    @ResponseBody
    public Map<String, String> withHeader(HttpServletRequest request) {
        return super.withHeader(request, request.getParameter("name"));
    }

    /**
     * 场景：获取cookie|header|query 内容
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/param/withHeader", method = {RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public Map<String, String> withHeaderBodyParam(HttpServletRequest request, @RequestBody String name) {
        return super.withHeader(request, name);
    }

    /**
     * 场景：获取header 多参数共传
     *
     * @return
     */
    @RequestMapping(value = "/param/moreParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, Object> moreParam(@CookieParam("param") String param, @HeaderParam("userName") String userName, @QueryParam("age") String age) {
        return super.moreParam(param, userName, age);
    }

    /**
     * 场景：模拟超时
     *
     * @param param
     */
    @RequestMapping(value = "/timeout", method = {RequestMethod.GET, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> timeout(@RequestParam("param") String param) {
        return super.timeout(param);
    }

    /**
     * 场景：模拟超时
     *
     * @param param
     */
    @RequestMapping(value = "/timeout", method = {RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public Map<String, String> timeoutBodyParam(@RequestBody String param) {
        return super.timeout(param);
    }

    /**
     * 测试场景：测试缓存
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/cache", method = {RequestMethod.GET, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> cache(@RequestParam("param") String param) {
        return super.cache(param);
    }

    /**
     * 测试场景：测试缓存
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/cache", method = {RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public Map<String, String> cacheBodyParam(@RequestBody String param) {
        return super.cache(param);
    }

    /**
     * 测试场景：外部授权body传参
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/param/authBodyParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> authBodyParam(String param, HttpServletRequest request) {
        return super.authBodyParam(param, request);
    }

    /**
     * 测试场景：请求参数映射
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/requestParamMapping", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public List<JSONObject> requestParamMapping(HttpServletRequest request, @RequestBody List<JSONObject> jsonObject) {
        return super.requestParamMapping(request, jsonObject);
    }

    /**
     * 测试场景：响应参数映射
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/responseParamMapping", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public JSONObject responseParamMapping(HttpServletRequest request, @RequestBody List<JSONObject> jsonObject) {
        return super.responseParamMapping(request, jsonObject);
    }

    /**
     * 测试场景：LDC路由
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/ldc", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, Object> ldc(HttpServletResponse response, HttpServletRequest request) {
        return super.ldc(response, request);
    }


    /**
     * 测试场景：返回 Object 无参
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/objectNoParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Object objectNoParam() {
        return super.objectNoParam();
    }

    /**
     * 测试场景：返回 Object 有参数
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/objectSimpleParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Object objectSimpleParam(@RequestBody User user) {
        return super.objectSimpleParam(user);
    }

    /**
     * 测试场景：返回 Map 无参
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/mapNoParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, String> mapNoParam() {
        return super.mapNoParam();
    }

    /**
     * 测试场景：返回 Map 有参数
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/mapSimpleParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public Map<String, User> mapSimpleParam(@RequestBody Map<String, User> map) {
        return super.mapSimpleParam(map);
    }

    /**
     * 测试场景：返回 List 无参
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/listNoParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public List<String> listNoParam() {
        return super.listNoParam();
    }

    /**
     * 测试场景：返回 List 有参数
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/listSimpleParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public List<User> listSimpleParam(@RequestBody List<User> list) {
        return super.listSimpleParam(list);
    }

    /**
     * 测试场景：返回StringOutput StringInput参数
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/param/stringInputParam", method = {RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @ResponseBody
    @Override
    public StringOutput inputParam(@RequestBody StringInput input) {
        return super.inputParam(input);
    }

}