package com.alipay.gateway.controller.others;

import com.alibaba.fastjson.JSON;
import com.alipay.gateway.vo.GatewayVO;
import com.alipay.sofa.gateway.api.client.ApiClient;
import com.alipay.sofa.gateway.api.client.DefaultApiClient;
import com.alipay.sofa.gateway.api.domain.ApiSecretKey;
import com.alipay.sofa.gateway.api.domain.request.GwSdkApiRequest;
import com.alipay.sofa.gateway.api.domain.response.ApiResponse;
import com.alipay.sofa.gateway.api.exception.ApiException;
import com.alipay.sofa.gateway.api.internal.parser.json.ObjectStringParser;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wb-hzb742209
 * @date 2020年12月4日 下午6:25:53
 */
@Controller
@RequestMapping("/")
public class GatewayHttpController {

    private ApiClient apiClient;

    /**
     * Gateway string.
     *
     * @param servletRequest the servlet request
     * @param gatewayVO      the gateway vo
     * @return the string
     */
    @ResponseBody
    @RequestMapping(value = "/gateway", method = RequestMethod.GET)
    public String gateway(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty(host)) {
            return "x-gateway-host 不能为空";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty(gatewayUrl)) {
            return "gatewayUrl 不能为空";
        }
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        String queryParams = gatewayVO.getQueryParams();
        String headerParams = gatewayVO.getHeaderParams();
        String cookieParams = gatewayVO.getCookieParams();
        HashMap<String, Object> map = Maps.newHashMap();
        Map queryMap = (Map) JSON.parse(queryParams);
        Map headerMap = (Map) JSON.parse(headerParams);
        Map cookieMap = (Map) JSON.parse(cookieParams);

        GwSdkApiRequest request = new GwSdkApiRequest();
        if (queryMap != null) {
            map.putAll(queryMap);
        }
        if (headerMap != null) {
            map.putAll(headerMap);
            request.getHeaderParams().putAll(headerMap);
        }
        if (cookieMap != null) {
            map.putAll(cookieMap);
        }
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("GET");
        request.getHeaderParams().put("x-gateway-host", host);
        request.getBizParams().putAll(map);
        request.setBody(map);

        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            List<ApiSecretKey> secretKeys = new ArrayList<>();
            secretKeys.add(apiSecretKey);
            apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient) apiClient).setNeedDetailResponse(true);
            response = apiClient.execute(request,
                new ObjectStringParser<>(request.getResponseClass()));
        } catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString(responseBody);
    }

    /**
     * Gateway post string.
     *
     * @param servletRequest the servlet request
     * @param gatewayVO      the gateway vo
     * @return the string
     */
    @ResponseBody
    @RequestMapping(value = "/gateway", method = RequestMethod.POST)
    public String gatewayPost(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty(host)) {
            return "x-gateway-host 不能为空";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty(gatewayUrl)) {
            return "gatewayUrl 不能为空";
        }
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        String queryParams = gatewayVO.getQueryParams();
        String headerParams = gatewayVO.getHeaderParams();
        String cookieParams = gatewayVO.getCookieParams();
        HashMap<String, Object> map = Maps.newHashMap();
        Map queryMap = (Map) JSON.parse(queryParams);
        Map headerMap = (Map) JSON.parse(headerParams);
        Map cookieMap = (Map) JSON.parse(cookieParams);

        GwSdkApiRequest request = new GwSdkApiRequest();
        if (queryMap != null) {
            map.putAll(queryMap);
        }
        if (headerMap != null) {
            map.putAll(headerMap);
            request.getHeaderParams().putAll(headerMap);
        }
        if (cookieMap != null) {
            map.putAll(cookieMap);
        }
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("POST");
        request.getHeaderParams().put("x-gateway-host", host);
        request.getBizParams().putAll(map);
        request.setBody(map);

        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            List<ApiSecretKey> secretKeys = new ArrayList<>();
            secretKeys.add(apiSecretKey);
            apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient) apiClient).setNeedDetailResponse(true);
            response = apiClient.execute(request,
                new ObjectStringParser<>(request.getResponseClass()));
        } catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString(responseBody);
    }

    /**
     * Gateway put string.
     *
     * @param servletRequest the servlet request
     * @param gatewayVO      the gateway vo
     * @return the string
     */
    @ResponseBody
    @RequestMapping(value = "/gateway", method = RequestMethod.PUT)
    public String gatewayPut(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty(host)) {
            return "x-gateway-host 不能为空";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty(gatewayUrl)) {
            return "gatewayUrl 不能为空";
        }
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        String queryParams = gatewayVO.getQueryParams();
        String headerParams = gatewayVO.getHeaderParams();
        String cookieParams = gatewayVO.getCookieParams();
        HashMap<String, Object> map = Maps.newHashMap();
        Map queryMap = (Map) JSON.parse(queryParams);
        Map headerMap = (Map) JSON.parse(headerParams);
        Map cookieMap = (Map) JSON.parse(cookieParams);

        GwSdkApiRequest request = new GwSdkApiRequest();
        if (queryMap != null) {
            map.putAll(queryMap);
        }
        if (headerMap != null) {
            map.putAll(headerMap);
            request.getHeaderParams().putAll(headerMap);
        }
        if (cookieMap != null) {
            map.putAll(cookieMap);
        }
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("PUT");
        request.getHeaderParams().put("x-gateway-host", host);
        request.getBizParams().putAll(map);
        request.setBody(map);

        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            List<ApiSecretKey> secretKeys = new ArrayList<>();
            secretKeys.add(apiSecretKey);
            apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient) apiClient).setNeedDetailResponse(true);
            response = apiClient.execute(request,
                new ObjectStringParser<>(request.getResponseClass()));
        } catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString(responseBody);
    }

    /**
     * Gateway delete string.
     *
     * @param servletRequest the servlet request
     * @param gatewayVO      the gateway vo
     * @return the string
     */
    @ResponseBody
    @RequestMapping(value = "/gateway", method = RequestMethod.DELETE)
    public String gatewayDelete(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty(host)) {
            return "x-gateway-host 不能为空";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty(gatewayUrl)) {
            return "gatewayUrl 不能为空";
        }
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();
        String queryParams = gatewayVO.getQueryParams();
        String headerParams = gatewayVO.getHeaderParams();
        String cookieParams = gatewayVO.getCookieParams();
        HashMap<String, Object> map = Maps.newHashMap();
        Map queryMap = (Map) JSON.parse(queryParams);
        Map headerMap = (Map) JSON.parse(headerParams);
        Map cookieMap = (Map) JSON.parse(cookieParams);

        GwSdkApiRequest request = new GwSdkApiRequest();
        if (queryMap != null) {
            map.putAll(queryMap);
        }
        if (headerMap != null) {
            map.putAll(headerMap);
            request.getHeaderParams().putAll(headerMap);
        }
        if (cookieMap != null) {
            map.putAll(cookieMap);
        }
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("DELETE");
        request.getHeaderParams().put("x-gateway-host", host);
        request.getBizParams().putAll(map);
        request.setBody(map);

        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            List<ApiSecretKey> secretKeys = new ArrayList<>();
            secretKeys.add(apiSecretKey);
            apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient) apiClient).setNeedDetailResponse(true);
            response = apiClient.execute(request,
                new ObjectStringParser<>(request.getResponseClass()));
        } catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString(responseBody);
    }
}
