package com.alipay.gateway.controller.others;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.gateway.vo.GatewayVO;
import com.alipay.sofa.gateway.api.client.ApiClient;
import com.alipay.sofa.gateway.api.client.DefaultApiClient;
import com.alipay.sofa.gateway.api.domain.ApiSecretKey;
import com.alipay.sofa.gateway.api.domain.request.GwSdkApiRequest;
import com.alipay.sofa.gateway.api.domain.response.ApiResponse;
import com.alipay.sofa.gateway.api.exception.ApiException;
import com.alipay.sofa.gateway.api.internal.parser.json.ObjectStringParser;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wb-hzb742209
 * @date 2020年12月4日 下午6:25:53
 */
@Controller
@RequestMapping("/rpc")
public class GatewayRpcController {

    private ApiClient apiClient;

    /**
     * Gateway string.
     *
     * @param servletRequest the servlet request
     * @param gatewayVO      the gateway vo
     * @return the string
     */
    @ResponseBody
    @RequestMapping(value = "/gateway", method = RequestMethod.GET)
    public String gateway(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty(host)) {
            return "x-gateway-host 不能为空";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty(gatewayUrl)) {
            return "gatewayUrl 不能为空";
        }
        String bodyParams = gatewayVO.getBodyParams();
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();

        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("GET");
        request.getHeaderParams().put("x-gateway-host", host);
        request.setBody(bodyParams);
        if (StringUtils.isNotBlank(bodyParams)) {
            if (bodyParams.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray(bodyParams);
                request.setBody(jsonArray);
            } else if (bodyParams.startsWith("{")) {
                JSONObject jsonObject = JSONObject.parseObject(bodyParams);
                request.setBody(jsonObject);
            }
        } else {
            request.setBody(null);
        }

        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            List<ApiSecretKey> secretKeys = new ArrayList<>();
            secretKeys.add(apiSecretKey);
            apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient) apiClient).setNeedDetailResponse(true);
            response = apiClient.execute(request,
                new ObjectStringParser<>(request.getResponseClass()));
        } catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString(responseBody);
    }

    /**
     * Gateway post string.
     *
     * @param servletRequest the servlet request
     * @param gatewayVO      the gateway vo
     * @return the string
     */
    @ResponseBody
    @RequestMapping(value = "/gateway", method = RequestMethod.POST)
    public String gatewayPost(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty(host)) {
            return "x-gateway-host 不能为空";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty(gatewayUrl)) {
            return "gatewayUrl 不能为空";
        }
        String bodyParams = gatewayVO.getBodyParams();
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();

        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("POST");
        request.getHeaderParams().put("x-gateway-host", host);
        request.setBody(bodyParams);
        if (StringUtils.isNotBlank(bodyParams)) {
            if (bodyParams.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray(bodyParams);
                request.setBody(jsonArray);
            } else if (bodyParams.startsWith("{")) {
                JSONObject jsonObject = JSONObject.parseObject(bodyParams);
                request.setBody(jsonObject);
            }
        } else {
            request.setBody(null);
        }

        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            List<ApiSecretKey> secretKeys = new ArrayList<>();
            secretKeys.add(apiSecretKey);
            apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient) apiClient).setNeedDetailResponse(true);
            response = apiClient.execute(request,
                new ObjectStringParser<>(request.getResponseClass()));
        } catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString(responseBody);
    }

    /**
     * Gateway put string.
     *
     * @param servletRequest the servlet request
     * @param gatewayVO      the gateway vo
     * @return the string
     */
    @ResponseBody
    @RequestMapping(value = "/gateway", method = RequestMethod.PUT)
    public String gatewayPut(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty(host)) {
            return "x-gateway-host 不能为空";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty(gatewayUrl)) {
            return "gatewayUrl 不能为空";
        }
        String bodyParams = gatewayVO.getBodyParams();
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();

        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("PUT");
        request.getHeaderParams().put("x-gateway-host", host);
        request.setBody(bodyParams);
        if (StringUtils.isNotBlank(bodyParams)) {
            if (bodyParams.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray(bodyParams);
                request.setBody(jsonArray);
            } else if (bodyParams.startsWith("{")) {
                JSONObject jsonObject = JSONObject.parseObject(bodyParams);
                request.setBody(jsonObject);
            }
        } else {
            request.setBody(null);
        }

        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            List<ApiSecretKey> secretKeys = new ArrayList<>();
            secretKeys.add(apiSecretKey);
            apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient) apiClient).setNeedDetailResponse(true);
            response = apiClient.execute(request,
                new ObjectStringParser<>(request.getResponseClass()));
        } catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString(responseBody);
    }

    /**
     * Gateway delete string.
     *
     * @param servletRequest the servlet request
     * @param gatewayVO      the gateway vo
     * @return the string
     */
    @ResponseBody
    @RequestMapping(value = "/gateway", method = RequestMethod.DELETE)
    public String gatewayDelete(HttpServletRequest servletRequest, GatewayVO gatewayVO) {
        String host = servletRequest.getHeader("x-gateway-host");
        if (StringUtils.isEmpty(host)) {
            return "x-gateway-host 不能为空";
        }
        String gatewayUrl = gatewayVO.getGatewayUrl();
        if (StringUtils.isEmpty(gatewayUrl)) {
            return "gatewayUrl 不能为空";
        }
        String bodyParams = gatewayVO.getBodyParams();
        String path = gatewayVO.getPath();
        boolean checkSign = gatewayVO.getCheckSign();
        String accessKey = gatewayVO.getAccessKey();
        String secretKey = gatewayVO.getSecretKey();

        GwSdkApiRequest request = new GwSdkApiRequest();
        request.setClientCheckSign(checkSign);
        request.setPath(path);
        request.setRequestType("DELETE");
        request.getHeaderParams().put("x-gateway-host", host);
        request.setBody(bodyParams);
        if (StringUtils.isNotBlank(bodyParams)) {
            if (bodyParams.startsWith("[")) {
                JSONArray jsonArray = JSONObject.parseArray(bodyParams);
                request.setBody(jsonArray);
            } else if (bodyParams.startsWith("{")) {
                JSONObject jsonObject = JSONObject.parseObject(bodyParams);
                request.setBody(jsonObject);
            }
        } else {
            request.setBody(null);
        }

        ApiResponse response = null;
        try {
            ApiSecretKey apiSecretKey = new ApiSecretKey(accessKey, secretKey);
            List<ApiSecretKey> secretKeys = new ArrayList<>();
            secretKeys.add(apiSecretKey);
            apiClient = new DefaultApiClient(gatewayUrl, secretKeys);
            ((DefaultApiClient) apiClient).setNeedDetailResponse(true);
            response = apiClient.execute(request,
                new ObjectStringParser<>(request.getResponseClass()));
        } catch (ApiException e) {
            return e.toString();
        }
        String responseBody = response.getBody();
        return JSON.toJSONString(responseBody);
    }
}
