package com.alipay.gateway.controller.rest;

import com.alipay.gateway.facade.model.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;

@RestController
public class RestServerController {

    @RequestMapping(value = "/saga/getMyEntity", method = RequestMethod.POST)
    public MyEntity sagaJson2(String flag) {
        MyEntity myEntity = new MyEntity();

        if (StringUtils.equalsIgnoreCase("flag", flag)) {
            myEntity.setFlag(flag);
            myEntity.setLog(myEntity.getLog() + "[invoke+1]");
        }
        System.out.println("###myEntity=" + myEntity);
        return myEntity;
    }

    @RequestMapping(value = "/springmvc/test/saga/getMyEntityBase", method = RequestMethod.POST)
    public MyEntityBase sagaJson3(@RequestBody String flag) {
        MyEntityBase myEntityBase = new MyEntityBase();

//        if (StringUtils.equalsIgnoreCase("flag", flag)) {
        if(flag.contains("flag")){
            myEntityBase.setFlag(flag);
            myEntityBase.setLog(myEntityBase.getLog() + "[invoke+1]");
        }
        System.out.println("###myEntityBase=" + myEntityBase);
        return myEntityBase;
    }

    //88888888888888888888888888888888888888888888888888888888888888888888888888





    @RequestMapping(value = "/saga/getTourist", method = RequestMethod.POST)
    public Tourist sagaJson(String idCard) {

        Tourist tourist = new Tourist();
        if (StringUtils.equalsIgnoreCase("666", idCard)) {
            tourist.setIdCard(idCard);
            tourist.setAge(22);
            tourist.setName("小强");
            tourist.setSex("男");
            tourist.setPhones(Arrays.asList("8697852", "8697853"));
        }
        System.out.println("###tourist=" + tourist);
        return tourist;
    }

    @RequestMapping(value = "/saga/getPoint", method = RequestMethod.POST)
    public Point sagaJson(@RequestBody Point point) {

        Point point2 = new Point();
        if (StringUtils.equalsIgnoreCase("小丽", point.getWifeName()) && StringUtils.equalsIgnoreCase("8", String.valueOf(point.getPhones().get(0).charAt(0)))  ) {
            point2 = point;
            point2.setWifeName("小丽");
            point2.setCount("100");
        }
        System.out.println("###point2=" + point2);
        return point2;
    }

    @RequestMapping(value = "/saga/getShip", method = RequestMethod.POST)
    public Ship sagaJson(@RequestBody Ship ship) {

        Ship ship2 = new Ship();
        if (StringUtils.equalsIgnoreCase("小丽", ship.getWifeName())) {
            ship2 = ship;
        }
        System.out.println("###ship2=" + ship2);
        return ship2;
    }

    @RequestMapping(value = "/springmvc/test/saga/getApiParam1", method = RequestMethod.POST)
    public String getApiParam1(String param )   {
//      public String getApiParam1(@RequestBody  String param) throws UnsupportedEncodingException {

        System.out.println("###getApiParam1: " + " param=" + param );
        return  param ;
    }

    @RequestMapping(value = "/saga/getApiParam1New", method = RequestMethod.POST)
    public String getApiParam1New(@RequestBody  String param) throws UnsupportedEncodingException {
        System.out.println("###getApiParam1: " + param);
//        HashMap<String,String> map = new HashMap<>();
//        map.put(k,v);
//        param = URLDecoder.decode(param,"utf-8");
        return param;
    }

    @RequestMapping(value = "/springmvc/test/saga/getApiParam2", method = RequestMethod.POST)
    public String getApiParam2(@RequestBody String param) {
        return param;
    }

    @RequestMapping(value = "/springmvc/test/saga/getApiParam3", method = RequestMethod.POST)
    public String getApiParam3(@RequestBody String param) {
        return param;
    }

    @RequestMapping(value = "/springmvc/test/saga/getApiParam1Sign", method = RequestMethod.POST)
    public String getApiParam1Sign(@CookieValue("myName") String myName, @CookieValue("yourName") String yourName, @RequestHeader("param")  String aheader )   {
        System.out.println("###getApiParam1Sign: myName=" + myName + ", yourName=" + yourName + ", aheader=" + aheader);

        return myName + " & "+ yourName + " & " + aheader;
    }




}
