/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.sofarest.nosign;

import com.alipay.gateway.facade.rest.nosign.SofaRestPutService;
import com.alipay.gateway.facade.model.User;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author wb-hzb742209
 * @date 2020年12月2日 下午7:00:43
 */
//@Service
//@SofaService(bindings = {@SofaServiceBinding(bindingType = "rest")}, uniqueId = "rpc-test-1112")
public class SofaRestPutServiceImpl implements SofaRestPutService {
    @Override
    public String noParam() {
        return "hello";
    }

    @Override
    public String sampleParam(String param) {
        return "hello:" + param;
    }

    @Override
    public String uidParam(String uid) {
        return "hello:" + uid;
    }

    @Override
    public String moreParam(String param, String param1, String param2) {
        return "hello:" + param + ";" + param1 + ";" + param2;
    }

    @Override
    public Map<String, String> headerParam(HttpServletRequest request) {
        String uid = request.getHeader("uid_of_header");
        String name = request.getParameter("name");
        Map<String, String> map = Maps.newHashMap();
        map.put("uid", uid);
        map.put("name", name);
        return map;
    }

    @Override
    public Map<String, Object> jsonParam(User user) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("user", user);
        return map;
    }

    @Override
    public Map<String, Object> formParam(String name, String age) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("name", name);
        map.put("age", age);
        return map;
    }

    @Override
    public String timeout(String sleepTime) {
        try {
            Thread.sleep(Long.valueOf(sleepTime));
        } catch (Exception e) {
        }
        return sleepTime;
    }

    @Override
    public void exception() throws Exception {
        throw new Exception("test exception");
    }

    @Override
    public Map<String, String> hello() {
        Map<String, String> map = new HashMap<>();
        map.put("rest", "hello");
        return map;
    }

    @Override
    public User objectNoParam() {
        User user = new User("rpc", 123);
        return user;
    }

    @Override
    public User objectSimpleParam(User user) { return user; }

    @Override
    public Map<String, String> mapNoParam() {
        Map<String, String> map = new HashMap<>();
        map.put("map", "hello");
        return map;
    }

    @Override
//    public Map<String, String> mapSimpleParam(Map<String, String> map) { return map; }
    public Map<String, User> mapSimpleParam(@RequestBody Map<String, User> map) {return map;}

    @Override
    public List<String> listNoParam() {
        List<String> list = new ArrayList<>();
        list.add("aaa");
        return list;
    }

    @Override
//    public List<String> listSimpleParam(List<String> list) { return list; }
    public List<User> listSimpleParam(@RequestBody List<User> list) {
        return list;
    }

    @Override
    public String getApiParam3(String param) {
        return param;
    }
}