package com.alipay.gateway.sofarpc;

import com.alipay.gateway.facade.model.Account;
import com.alipay.gateway.facade.model.AccountQueryResult;
import com.alipay.gateway.facade.model.AccountSer;
import com.alipay.gateway.facade.rpc.GatewayRpcDeserializeService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author 蕖兰
 * @Date 2021/11/12 5:22 下午
 * @Description
 */
@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class GatewayRpcDeserializeServiceImpl implements GatewayRpcDeserializeService {

    @Override
    public AccountQueryResult queryAccountBalance(String accountNo) {

        AccountQueryResult accountQueryResult = new AccountQueryResult();
        Account account = new Account(accountNo, new BigDecimal(11111111), new BigDecimal(22222222), new BigDecimal(33333333));
        accountQueryResult.setSuccess(true);
        accountQueryResult.setAccount(account);
        accountQueryResult.setMsgCode("200");
        accountQueryResult.setMsgText("success");

        return accountQueryResult;
    }

    @Override
    public Map<String, String> hello() {

        Map<String, String> map = new HashMap<>();
        map.put("targetIp", getLocalIpAddress());

        return map;
    }

    @Override
    public Account queryAccount(String accountNo) {
        Account account = new Account(accountNo, new BigDecimal(11111111), new BigDecimal(22222222), new BigDecimal(33333333));
        return account;
    }

    @Override
    public BigDecimal queryAccountBalance2(Account account) {

        return new BigDecimal(account.getAccountNo());
    }

    @Override
    public AccountSer queryAccountSer(String accountNo) {
        return new AccountSer(accountNo, new BigDecimal(11111111), new BigDecimal(22222222), new BigDecimal(33333333));
    }

    @Override
    public BigDecimal queryAccountSerBalance2(AccountSer accountSer) {
        return new BigDecimal(accountSer.getAccountNo());
    }

    public static String getLocalIpAddress() {

        try {
            long start = System.currentTimeMillis();
            InetAddress localHost = InetAddress.getLocalHost();
            long end = System.currentTimeMillis();
            System.out.println("end-start = " + (end - start));
            String ip = localHost.getHostAddress();
            if (StringUtils.isNotEmpty(ip) && !StringUtils.equalsIgnoreCase(ip, "127.0.0.1")) {
                return ip;
            }
        } catch (UnknownHostException e) {
            throw new RuntimeException("get localhost information error", e);
        }
        throw new RuntimeException("local ip is empty");

    }
}
