package com.alipay.gateway.sofarpc;

import com.alipay.gateway.facade.rpc.GatewayRpcNoAuthService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @Author 蕖兰
 * @Date 2021/11/12 5:22 下午
 * @Description
 */
@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class GatewayRpcNoAuthServiceImpl implements GatewayRpcNoAuthService {

    @Override
    public String hello() {
        return "hello noParamForString";
    }

    @Override
    public Map<String, String> noParamForMap() {
        Map<String, String> map = Maps.newHashMap();
        map.put("result", "noParamForMap");
        return map;
    }

    @Override
    public String simpleParam(String param) {
        return "hello simpleParamForString " + param;
    }

    @Override
    public Map<String, String> simpleParamForMap(String param) {
        Map<String, String> map = Maps.newHashMap();
        map.put("result", "simpleParamForMap " + param);
        return map;
    }
}
