package com.alipay.gateway.sofarpc;

import com.alipay.gateway.facade.model.User;
import com.alipay.gateway.facade.rpc.TestParamRpcService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author zxy
 * @date 2020-12-10
 */
@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class TestParamRpcServiceImpl implements TestParamRpcService {

    @Override
    public Object message() {
        return "Hello, message";
    }

    @Override
    public String getString(String str) {
        return str;
    }

    @Override
    public Integer getInteger(Integer num) {
        return num;
    }

    @Override
    public Boolean getBoolean(Boolean bool) {
        return bool;
    }

    @Override
    public List<User> getUserList(List<User> list) {
        return list;
    }

    @Override
    public String[] getStringArray(String[] strArr) {
        return strArr;
    }

    @Override
    public int[] getIntArray(int[] intArr) {
        return intArr;
    }

    @Override
    public User getUser(User u) {
        return u;
    }

    @Override
    public Map<String, List<String>> getMapStringList(Map<String, List<String>> obj) {
        return obj;
    }

    @Override
    public Map<Object, Object> getMapObject(Map<Object, Object> obj) {
        return obj;
    }

    @Override
    public List<Object> getObjectList(List<Object> objList) {
        return objList;
    }

    @Override
    public List<Object> getTwoObject(Object o1, Object o2) {
        return Arrays.asList(new Object[]{o1, o2});
    }

    @Override
    public List<Object> getThreeObject(Object o1, Object o2, Object o3) {
        return Arrays.asList(new Object[]{o1, o2, o3});
    }

    @Override
    public List<Object> getTwoUserObject(User u, Object o) {
        return Arrays.asList(new Object[]{u, o});
    }

    @Override
    public List<Object> getTwoUserDouble(User u, Double userId) {
        return Arrays.asList(new Object[]{u, userId});
    }

    @Override
    public List<Object> getTwoUserString(User u, String userId) {
        return Arrays.asList(new Object[]{u, userId});
    }

}
