package com.alipay.gateway.sofarpc.apiflow;

import com.alipay.gateway.facade.model.Point;
import com.alipay.gateway.facade.model.Ship;
import com.alipay.gateway.facade.model.Tourist;
import com.alipay.gateway.facade.rpc.apiflow.ApiflowRpcService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Author 蕖兰
 * @Date 2021/11/12 5:22 下午
 * @Description
 */
@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class ApiflowRpcServiceImpl implements ApiflowRpcService {

    @Override
    public Tourist getTourist(String idCard) {
        Tourist tourist = new Tourist();
        tourist.setIdCard(idCard);
        tourist.setAge(22);
        tourist.setName("小强");
        tourist.setSex("男");
        tourist.setPhones(java.util.Arrays.asList("8697852", "8697853"));

        System.out.println("###tourist=" + tourist);
        return tourist;
    }

    // 有使用
    @Override
    public Point getPoint(@RequestBody Point point) {   //需要入参手机号
        point.setWifeName("小丽");
        point.setCount("100");

        System.out.println("###point2=" + point);
        return point;
    }

    // 有使用
    @Override
    public Ship getShip(@RequestBody Ship ship) {    //需要入参wifeName
        ship.setIdCard("888");

        System.out.println("###ship2=" + ship);
        return ship;
    }

}
