package com.alipay.gateway.sofarpc.apiflow;

import com.alipay.gateway.facade.model.Point;
import com.alipay.gateway.facade.model.Ship;
import com.alipay.gateway.facade.model.Tourist;
import com.alipay.gateway.facade.rpc.apiflow.TestApiFlowRpcService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Author 蕖兰
 * @Date 2021/11/12 5:45 下午
 * @Description TODO
 */
@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class TestApiFlowRpcServiceImpl implements TestApiFlowRpcService {

    @Override
    public Point getPoint(@RequestBody Point point) {
        Point point2 = new Point();
        if (StringUtils.equalsIgnoreCase("小丽", point.getWifeName()) && "8".equalsIgnoreCase(String.valueOf(point.getPhones().get(0).charAt(0)))) {
            point2 = point;
            point2.setWifeName("小丽");
            point2.setCount("100");
        }
        System.out.println("###point2=" + point2);
        return point2;
    }

    @Override
    public Ship getShip(@RequestBody Ship ship) {
        Ship ship2 = new Ship();
        if (StringUtils.equalsIgnoreCase("小丽", ship.getWifeName())) {
            ship2 = ship;
        }
        System.out.println("###ship2=" + ship2);
        return ship2;
    }

    @Override
    public String getApiParam1(String param) {
        return param;
    }

    @Override
    public String getApiParam2(String param) {
        return param;
    }

    @Override
    public String getApiParam3(String param) {
        return param;
    }

    @Override
    public Tourist getTourist(String idCard) {

        Tourist tourist = new Tourist();
        if (StringUtils.equalsIgnoreCase("666", idCard)) {
            tourist.setIdCard(idCard);
            tourist.setAge(22);
            tourist.setName("小强");
            tourist.setSex("男");
            tourist.setPhones(java.util.Arrays.asList("8697852", "8697853"));
        }
        System.out.println("###tourist=" + tourist);
        return tourist;
    }
}
