package com.alipay.gateway.sofarpc.dubbo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.gateway.facade.exception.SelfDefineException;
import com.alipay.gateway.facade.rpc.RpcInNewOutNewService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.zjrc.common.domain.ResponseData;
import com.zjrc.common.domain.StringInput;
import com.zjrc.common.domain.StringOutput;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class RpcInNewOutNewServiceImpl implements RpcInNewOutNewService {

    @Override
    public StringOutput rpcInNewOutNew(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        if (!equals){
            //处理失败
            output.setBody(JSON.toJSONString("business is failure !"));
        }else {
            //业务处理成功
//            output.setBody(JSON.toJSONString("business is normal !"));
//            output.setBody("{\"AcctInfoList6\":[{\"BCO06CSNO\":null,\"BCO06EBNO\":null,\"BCO06CSTP\":null,\"BCO06ZZSM\":null,\"BCO06QMSF\":null,\"BCO06BRT1\":null,\"BCO06JMBZ\":null,\"BCO06CNCD\":null,\"BCO06RMRK\":null,\"BCO06BRNO1\":null,\"BCO06STAF1\":null,\"BCO06DATE1\":null,\"BCO06STAM1\":null,\"BCO06BRNO2\":null,\"BCO06STAF2\":null,\"BCO06DATE2\":null,\"BCO06STAM2\":null}],\"AcctInfoList5\":[{\"BCO05CSNO\":null,\"BCO05WORK\":null,\"BCO05WKDT\":null,\"BCO05SETP\":null,\"BCO05BRNO1\":null,\"BCO05STAF1\":null,\"BCO05DATE1\":null,\"BCO05STAM1\":null,\"BCO05BRNO2\":null,\"BCO05STAF2\":null,\"BCO05DATE2\":null,\"BCO05STAM2\":null}],\"AcctInfoList4\":[{\"BCO04ISID\":\"B\",\"BCO04CSNO\":\"81072537334\",\"BCO04PTSN\":\"02\",\"BCO04TLTP\":\"6\",\"BCO04TELN\":\"18855167644\",\"BCO04RS1B\":null,\"BCO04ST16\":\"0000000000000000\",\"BCO04BRNO1\":\"861059\",\"BCO04BRBM1\":\"861\",\"BCO04STAF1\":\"8610710\",\"BCO04DATE1\":\"20121114\",\"BCO04STAM1\":\"2012-11-14-13.54.58.089000\",\"BCO04BRNO2\":\"861059\",\"BCO04BRBM2\":null,\"BCO04STAF2\":\"999AUTO\",\"BCO04DATE2\":\"20170627\",\"BCO04STAM2\":\"2016-12-14-22.23.26.046000\"},{\"BCO04ISID\":\"B\",\"BCO04CSNO\":\"81072537334\",\"BCO04PTSN\":\"03\",\"BCO04TLTP\":\"1\",\"BCO04TELN\":\"18855167644\",\"BCO04RS1B\":null,\"BCO04ST16\":\"0000000000000000\",\"BCO04BRNO1\":\"861271\",\"BCO04BRBM1\":\"861\",\"BCO04STAF1\":\"8610267\",\"BCO04DATE1\":\"20161214\",\"BCO04STAM1\":\"2016-12-14-16.14.34.552000\",\"BCO04BRNO2\":\"861271\",\"BCO04BRBM2\":null,\"BCO04STAF2\":\"999AUTO\",\"BCO04DATE2\":\"20170706\",\"BCO04STAM2\":\"2016-12-14-16.14.34.552000\"}],\"AcctInfoList3\":[{\"BCO03ISID\":\"B\",\"BCO03CSNO\":\"81072537334\",\"BCO03PTSN\":\"01\",\"BCO03ADTP\":\"1\",\"BCO03RGNM\":\"350924\",\"BCO03ADDR1\":\"福建省宁德市寿宁县鳌阳镇东区景泰街16号新城印象2幢C单元801\",\"BCO03ADDR2\":null,\"BCO03AD80\":null,\"BCO03ZPCD\":\"325802\",\"BCO03RS1B\":null,\"BCO03ST16\":\"      0000000000\",\"BCO03BRNO1\":\"861059\",\"BCO03BRBM1\":\"861\",\"BCO03STAF1\":\"8610710\",\"BCO03DATE1\":\"20121114\",\"BCO03STAM1\":\"2012-11-14-13.54.58.089000\",\"BCO03BRNO2\":\"861059\",\"BCO03BRBM2\":null,\"BCO03STAF2\":\"999AUTO\",\"BCO03DATE2\":\"20170627\",\"BCO03STAM3\":\"2016-12-14-16.14.34.536000\"},{\"BCO03ISID\":\"B\",\"BCO03CSNO\":\"81072537334\",\"BCO03PTSN\":\"02\",\"BCO03ADTP\":\"0\",\"BCO03RGNM\":\"350924\",\"BCO03ADDR1\":\"福建省宁德市寿宁县鳌阳镇东区景泰街16号新城印象2幢C单元801\",\"BCO03ADDR2\":null,\"BCO03AD80\":null,\"BCO03ZPCD\":\"325802\",\"BCO03RS1B\":null,\"BCO03ST16\":\"      0000000000\",\"BCO03BRNO1\":\"861271\",\"BCO03BRBM1\":\"861\",\"BCO03STAF1\":\"8610267\",\"BCO03DATE1\":\"20161214\",\"BCO03STAM1\":\"2016-12-14-16.14.34.541000\",\"BCO03BRNO2\":\"861271\",\"BCO03BRBM2\":null,\"BCO03STAF2\":\"999AUTO\",\"BCO03DATE2\":\"20170706\",\"BCO03STAM3\":\"2016-12-14-16.14.34.541000\"}],\"AcctInfoList2\":[{\"BCO02ISID\":\"B\",\"BCO02CSNO\":\"81072537334\",\"BCO02CFTP\":\"101\",\"BCO02CFNO\":\"352229198804162681\",\"BCO02BOOL\":\"1\",\"BCO02NM5B\":\"陈光梅\",\"BCO02DATE1\":\"20150917\",\"BCO02DATE2\":\"20250917\",\"BCO02CNTY\":null,\"BCO02ISBU\":null,\"BCO02YE1B\":null,\"BCO02RS1B\":null,\"BCO02ST16\":\"  00000000000000\",\"BCO02BRNO1\":\"861059\",\"BCO02BRBM1\":null,\"BCO02STAF1\":\"8610710\",\"BCO02DATE3\":\"20121114\",\"BCO02STAM1\":\"2012-11-14-13.54.58.089000\",\"BCO02BRNO2\":\"861059\",\"BCO02BRBM2\":null,\"BCO02STAF2\":\"999AUTO\",\"BCO02DATE4\":\"20170627\",\"BCO02STAM2\":\"2016-12-14-16.14.34.535000\"}],\"AcctInfoList1\":[{\"BCO01ISID\":\"B\",\"BCO01CSNO\":\"81072537334\",\"BCO01BOOL\":\"1\",\"BCO01CSID\":\"101352229198804162681\",\"BCO01FLNM\":\"问米荣\",\"BCO01NM3B\":null,\"BCO01EN80\":null,\"BCO01CNTY\":\"156\",\"BCO01LANG\":\"C\",\"BCO01PTSN1\":\"01\",\"BCO01PTSN2\":\"02\",\"BCO01CSST\":null,\"BCO01VIPT\":\"2\",\"BCO01PTSN3\":\"02\",\"BCO01PTSN4\":\"03\",\"BCO01PTSN5\":null,\"BCO01PTSN6\":null,\"BCO01PTSN7\":null,\"BCO01PTSN8\":null,\"BCO01PTSN9\":null,\"BCO01BRNO1\":\"861151\",\"BCO01BRBM1\":null,\"BCO01STAF1\":null,\"BCO01NM201\":null,\"BCO01NM202\":null,\"BCO01NM40\":null,\"BCO01CU1B\":null,\"BCO01RS1B\":null,\"BCO01ST16\":\"1111000000000000\",\"BCO01BRNO2\":\"861059\",\"BCO01BRBM2\":null,\"BCO01STAF2\":\"8610710\",\"BCO01DATE1\":\"20121114\",\"BCO01STAM1\":\"2012-11-14-13.54.58.089000\",\"BCO01BRNO3\":\"861059\",\"BCO01BRBM3\":null,\"BCO01STAF3\":\"999AUTO\",\"BCO01DATE2\":\"20170627\",\"BCO01STAM2\":\"2016-12-14-16.14.34.535000\"}]}");
            output.setBody("{\"List\":[{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"626AUTO\",\"BBO01ANM20\":\"惠水恒升村镇批处理\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"8\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"8\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"8\",\"BBO01APWLV\":\"9\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"999000\",\"BBO01CBRNO\":\"999000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20061203\",\"BBO01BDATE\":\"20720527\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20061203\",\"BBO01AOPTS\":null,\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260002\",\"BBO01ANM20\":\"李驹\",\"BBO01ACFNO\":\"522731197409300032\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13765491988\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5111\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140123\",\"BBO01BDATE\":\"20640122\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20140124\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220527\",\"BBO01GDATE\":\"20140305\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260003\",\"BBO01ANM20\":\"陈昌华\",\"BBO01ACFNO\":\"522731197212020010\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13508547688\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\" ,\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140122\",\"BBO01BDATE\":\"20640121\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20170727\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260004\",\"BBO01ANM20\":\"程波\",\"BBO01ACFNO\":\"522731196904010062\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13765770298\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"1\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140122\",\"BBO01BDATE\":\"20241210\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220807\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220720\",\"BBO01GDATE\":\"20211025\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260005\",\"BBO01ANM20\":\"王勇\",\"BBO01ACFNO\":\"522731198006250055\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13708548983\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20160905\",\"BBO01BDATE\":\"20260905\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20160906\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220412\",\"BBO01GDATE\":\"20191015\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260009\",\"BBO01ANM20\":\"吴俊\",\"BBO01ACFNO\":\"522731198807200015\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15885465707\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5113\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140119\",\"BBO01BDATE\":\"20640118\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20140221\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220720\",\"BBO01GDATE\":\"20220515\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260011\",\"BBO01ANM20\":\"唐贵强\",\"BBO01ACFNO\":\"500233198802278147\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18722895960\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"3\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5113\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140122\",\"BBO01BDATE\":\"20640121\",\"BBO01ABLNO\":\"80018578\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220812\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":\"1\",\"BBO01AMSST\":null,\"BBO01DDATE\":\"20220704\",\"BBO01EDATE\":\"20220704\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220713\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260013\",\"BBO01ANM20\":\"陈俊廷\",\"BBO01ACFNO\":\"522731198212230012\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18585134348\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140122\",\"BBO01BDATE\":\"20640121\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20140123\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220721\",\"BBO01GDATE\":\"20201109\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260017\",\"BBO01ANM20\":\"潘堂品\",\"BBO01ACFNO\":\"52270119880918281X\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18286482019\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6116\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140118\",\"BBO01BDATE\":\"20231120\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20140309\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220721\",\"BBO01GDATE\":\"20220704\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260026\",\"BBO01ANM20\":\"花雄\",\"BBO01ACFNO\":\"522731199012139390\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18885463780\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20280603\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220622\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260028\",\"BBO01ANM20\":\"况金红\",\"BBO01ACFNO\":\"522731198602070026\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"15185486501\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6116\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260037\",\"BBO01ANM20\":\"苏盛涛\",\"BBO01ACFNO\":\"522731197011120015\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18684127239\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20280626\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20210924\",\"BBO01GDATE\":\"20191020\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260039\",\"BBO01ANM20\":\"罗吉槿\",\"BBO01ACFNO\":\"522729199008050025\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18375206269\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150703\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150704\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220719\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260048\",\"BBO01ANM20\":\"孙文\",\"BBO01ACFNO\":\"522731199308150038\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18886436950\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6114\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20161108\",\"BBO01BDATE\":\"20281108\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20161109\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260051\",\"BBO01ANM20\":\"汪华琴\",\"BBO01ACFNO\":\"522731199103102200\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18798008226\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6114\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170526\",\"BBO01BDATE\":\"20270526\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170527\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220722\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260053\",\"BBO01ANM20\":\"陈海丰\",\"BBO01ACFNO\":\"330304198211086938\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15988789030\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170606\",\"BBO01BDATE\":\"20270606\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220515\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220722\",\"BBO01GDATE\":\"20220321\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260060\",\"BBO01ANM20\":\"禹小燕\",\"BBO01ACFNO\":\"522731199211225240\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18985063854\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"1\",\"BBO01GBOOL\":\"2\",\"BBO01HBOOL\":\"2\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6117\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"2\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"2\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20221205\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220531\",\"BBO01GDATE\":\"20220531\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260061\",\"BBO01ANM20\":\"黎人源\",\"BBO01ACFNO\":\"522731199310262549\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"15108549693\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260070\",\"BBO01ANM20\":\"周云惠\",\"BBO01ACFNO\":\"530426199712161022\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18085419474\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"1\",\"BBO01GBOOL\":\"2\",\"BBO01HBOOL\":\"2\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"6114\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"2\",\"BBO01BFLAG\":\"2\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20200430\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260075\",\"BBO01ANM20\":\"黄国栋\",\"BBO01ACFNO\":\"330323197201201239\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13505870654\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"3\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5111\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200914\",\"BBO01BDATE\":\"20300914\",\"BBO01ABLNO\":\"80018494\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220818\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":\"1\",\"BBO01AMSST\":null,\"BBO01DDATE\":\"20210402\",\"BBO01EDATE\":\"20210402\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260007\",\"BBO01ANM20\":\"杨戈\",\"BBO01ACFNO\":\"52273119860128003X\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15185498340\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140108\",\"BBO01BDATE\":\"20251215\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150311\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220722\",\"BBO01GDATE\":\"20220125\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260020\",\"BBO01ANM20\":\"龙太艳\",\"BBO01ACFNO\":\"522731198707062188\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"15180870975\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140118\",\"BBO01BDATE\":\"20640117\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20141017\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220720\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260024\",\"BBO01ANM20\":\"柴立静\",\"BBO01ACFNO\":\"52273119910507002X\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13885452212\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20250601\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220721\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260025\",\"BBO01ANM20\":\"高镭\",\"BBO01ACFNO\":\"522731199207212535\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15285328845\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20290514\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220714\",\"BBO01GDATE\":\"20220525\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260027\",\"BBO01ANM20\":\"张绚\",\"BBO01ACFNO\":\"522731199107014160\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18889281072\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7117\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220724\",\"BBO01GDATE\":\"20220724\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260030\",\"BBO01ANM20\":\"段国雄\",\"BBO01ACFNO\":\"522731198806042916\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18188548839\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7111\",\"BBO01ASTLE\":\"26\",\"BBO01APWLV\":\"26\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220614\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260032\",\"BBO01ANM20\":\"杨俊\",\"BBO01ACFNO\":\"522731198712065738\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18285484436\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7117\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"9\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260041\",\"BBO01ANM20\":\"揭燕荣\",\"BBO01ACFNO\":\"522731198708080038\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18685406412\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20151030\",\"BBO01BDATE\":\"20251030\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20151031\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20201123\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260050\",\"BBO01ANM20\":\"龙龙\",\"BBO01ACFNO\":\"522731199309170030\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15085140759\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170526\",\"BBO01BDATE\":\"20290515\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170527\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20191101\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260065\",\"BBO01ANM20\":\"张治航\",\"BBO01ACFNO\":\"522725199405151916\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15885432128\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220721\",\"BBO01GDATE\":\"20220721\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260069\",\"BBO01ANM20\":\"雷嵘旭\",\"BBO01ACFNO\":\"522731199410240013\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15723271024\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20200430\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220719\",\"BBO01GDATE\":\"20220622\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260079\",\"BBO01ANM20\":\"夏祺\",\"BBO01ACFNO\":\"522731199803140021\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18827029957\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"23\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260081\",\"BBO01ANM20\":\"刘鹏程\",\"BBO01ACFNO\":\"522731199511090034\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18886480034\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"19\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6268001\",\"BBO01ANM20\":\"A1626110\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150519\",\"BBO01BDATE\":\"20250519\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150520\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6268002\",\"BBO01ANM20\":\"A2626110\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150519\",\"BBO01BDATE\":\"20250519\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150520\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6268003\",\"BBO01ANM20\":\"A3626110\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150519\",\"BBO01BDATE\":\"20250519\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150520\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6268004\",\"BBO01ANM20\":\"F6261101\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20210222\",\"BBO01BDATE\":\"20310222\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20210223\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260031\",\"BBO01ANM20\":\"魏枭\",\"BBO01ACFNO\":\"522731199008100039\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18685311689\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220428\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260036\",\"BBO01ANM20\":\"陈作云\",\"BBO01ACFNO\":\"330321196511158750\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13906640997\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7111\",\"BBO01ASTLE\":\"26\",\"BBO01APWLV\":\"26\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20251220\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260043\",\"BBO01ANM20\":\"陈德宇\",\"BBO01ACFNO\":\"522731199304200034\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18885408541\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20160719\",\"BBO01BDATE\":\"20241220\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20210127\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20170804\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260047\",\"BBO01ANM20\":\"范进\",\"BBO01ACFNO\":\"522731198605240019\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13639059880\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20161108\",\"BBO01BDATE\":\"20261108\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20161109\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220711\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260058\",\"BBO01ANM20\":\"杨雯雯\",\"BBO01ACFNO\":\"522731199505160024\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13765444466\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260062\",\"BBO01ANM20\":\"龙青贤\",\"BBO01ACFNO\":\"522731199308102538\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15761204301\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"80018576\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220525\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":\"2\",\"BBO01AMSST\":null,\"BBO01DDATE\":\"20181119\",\"BBO01EDATE\":\"20181119\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20171122\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260063\",\"BBO01ANM20\":\"陈朗\",\"BBO01ACFNO\":\"520102199012305815\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13595433947\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20210220\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220422\",\"BBO01GDATE\":\"20181030\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260067\",\"BBO01ANM20\":\"龚双梅\",\"BBO01ACFNO\":\"522731199609289025\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18375201343\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"2\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220428\",\"BBO01GDATE\":\"20200513\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260068\",\"BBO01ANM20\":\"罗蒙\",\"BBO01ACFNO\":\"522731199209060045\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18185411520\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220724\",\"BBO01GDATE\":\"20220724\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260071\",\"BBO01ANM20\":\"杨廷连\",\"BBO01ACFNO\":\"522730199107081746\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13885483658\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7117\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20200430\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"3\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260072\",\"BBO01ANM20\":\"韦翰涌\",\"BBO01ACFNO\":\"522731199505253618\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15285322251\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20200430\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220722\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260073\",\"BBO01ANM20\":\"陈秋风\",\"BBO01ACFNO\":\"522731199210216131\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15885403802\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20201030\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220506\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260077\",\"BBO01ANM20\":\"张小丽\",\"BBO01ACFNO\":\"522731199803063804\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18659459326\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"18\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260078\",\"BBO01ANM20\":\"吴懿博\",\"BBO01ACFNO\":\"522731199609290026\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13312361564\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"2\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220216\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260080\",\"BBO01ANM20\":\"田霞霞\",\"BBO01ACFNO\":\"522731199803105744\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18385495964\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"8\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6268005\",\"BBO01ANM20\":\"F6261201\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20210918\",\"BBO01BDATE\":\"20310918\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20210919\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6268101\",\"BBO01ANM20\":\"A1626120\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150730\",\"BBO01BDATE\":\"20250730\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150731\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6268102\",\"BBO01ANM20\":\"A2626120\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150730\",\"BBO01BDATE\":\"20250730\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150731\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null}]}");
        }
        Map<String,String> map= Maps.newConcurrentMap();
        map.put("aaa","hello world !");
        System.out.println("handle success!");
        return output;
//        throw new SelfDefineException("input is invalid");
//        throw new RuntimeException();
    }

    @Override
    public StringOutput rpcInNewOutNewParam(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        ResponseData responseData = new ResponseData();
        if (!equals){
            //处理失败
            responseData.setCode("00000001");
            responseData.setMessage("失败");
            responseData.setServerIp("127.0.0.1");
            responseData.setReturnTime(new Date());
            responseData.setServcSeqNo("137egfd2387d27d832dgd7d276235423");
            responseData.setRecordCount(1000);
            responseData.setType("E");
            output.setBody(JSON.toJSONString("business is failure !"));
            output.setRespData(responseData);
        }else {
            //业务处理成功
            responseData.setCode("00000001");
            responseData.setMessage("成功");
            responseData.setServerIp("127.0.0.1");
            responseData.setReturnTime(new Date());
//            responseData.setReturnTime(null);
            responseData.setServcSeqNo("137egfd2387d27d832dgd7d276235423");
            responseData.setRecordCount(1000);
            responseData.setType("S");
//            output.setBody(JSON.toJSONString("business is normal !"));
//            output.setBody("{\"AcctInfoList6\":[{\"BCO06CSNO\":null,\"BCO06EBNO\":null,\"BCO06CSTP\":null,\"BCO06ZZSM\":null,\"BCO06QMSF\":null,\"BCO06BRT1\":null,\"BCO06JMBZ\":null,\"BCO06CNCD\":null,\"BCO06RMRK\":null,\"BCO06BRNO1\":null,\"BCO06STAF1\":null,\"BCO06DATE1\":null,\"BCO06STAM1\":null,\"BCO06BRNO2\":null,\"BCO06STAF2\":null,\"BCO06DATE2\":null,\"BCO06STAM2\":null}],\"AcctInfoList5\":[{\"BCO05CSNO\":null,\"BCO05WORK\":null,\"BCO05WKDT\":null,\"BCO05SETP\":null,\"BCO05BRNO1\":null,\"BCO05STAF1\":null,\"BCO05DATE1\":null,\"BCO05STAM1\":null,\"BCO05BRNO2\":null,\"BCO05STAF2\":null,\"BCO05DATE2\":null,\"BCO05STAM2\":null}],\"AcctInfoList4\":[{\"BCO04ISID\":\"B\",\"BCO04CSNO\":\"81072537334\",\"BCO04PTSN\":\"02\",\"BCO04TLTP\":\"6\",\"BCO04TELN\":\"18855167644\",\"BCO04RS1B\":null,\"BCO04ST16\":\"0000000000000000\",\"BCO04BRNO1\":\"861059\",\"BCO04BRBM1\":\"861\",\"BCO04STAF1\":\"8610710\",\"BCO04DATE1\":\"20121114\",\"BCO04STAM1\":\"2012-11-14-13.54.58.089000\",\"BCO04BRNO2\":\"861059\",\"BCO04BRBM2\":null,\"BCO04STAF2\":\"999AUTO\",\"BCO04DATE2\":\"20170627\",\"BCO04STAM2\":\"2016-12-14-22.23.26.046000\"},{\"BCO04ISID\":\"B\",\"BCO04CSNO\":\"81072537334\",\"BCO04PTSN\":\"03\",\"BCO04TLTP\":\"1\",\"BCO04TELN\":\"18855167644\",\"BCO04RS1B\":null,\"BCO04ST16\":\"0000000000000000\",\"BCO04BRNO1\":\"861271\",\"BCO04BRBM1\":\"861\",\"BCO04STAF1\":\"8610267\",\"BCO04DATE1\":\"20161214\",\"BCO04STAM1\":\"2016-12-14-16.14.34.552000\",\"BCO04BRNO2\":\"861271\",\"BCO04BRBM2\":null,\"BCO04STAF2\":\"999AUTO\",\"BCO04DATE2\":\"20170706\",\"BCO04STAM2\":\"2016-12-14-16.14.34.552000\"}],\"AcctInfoList3\":[{\"BCO03ISID\":\"B\",\"BCO03CSNO\":\"81072537334\",\"BCO03PTSN\":\"01\",\"BCO03ADTP\":\"1\",\"BCO03RGNM\":\"350924\",\"BCO03ADDR1\":\"福建省宁德市寿宁县鳌阳镇东区景泰街16号新城印象2幢C单元801\",\"BCO03ADDR2\":null,\"BCO03AD80\":null,\"BCO03ZPCD\":\"325802\",\"BCO03RS1B\":null,\"BCO03ST16\":\"      0000000000\",\"BCO03BRNO1\":\"861059\",\"BCO03BRBM1\":\"861\",\"BCO03STAF1\":\"8610710\",\"BCO03DATE1\":\"20121114\",\"BCO03STAM1\":\"2012-11-14-13.54.58.089000\",\"BCO03BRNO2\":\"861059\",\"BCO03BRBM2\":null,\"BCO03STAF2\":\"999AUTO\",\"BCO03DATE2\":\"20170627\",\"BCO03STAM3\":\"2016-12-14-16.14.34.536000\"},{\"BCO03ISID\":\"B\",\"BCO03CSNO\":\"81072537334\",\"BCO03PTSN\":\"02\",\"BCO03ADTP\":\"0\",\"BCO03RGNM\":\"350924\",\"BCO03ADDR1\":\"福建省宁德市寿宁县鳌阳镇东区景泰街16号新城印象2幢C单元801\",\"BCO03ADDR2\":null,\"BCO03AD80\":null,\"BCO03ZPCD\":\"325802\",\"BCO03RS1B\":null,\"BCO03ST16\":\"      0000000000\",\"BCO03BRNO1\":\"861271\",\"BCO03BRBM1\":\"861\",\"BCO03STAF1\":\"8610267\",\"BCO03DATE1\":\"20161214\",\"BCO03STAM1\":\"2016-12-14-16.14.34.541000\",\"BCO03BRNO2\":\"861271\",\"BCO03BRBM2\":null,\"BCO03STAF2\":\"999AUTO\",\"BCO03DATE2\":\"20170706\",\"BCO03STAM3\":\"2016-12-14-16.14.34.541000\"}],\"AcctInfoList2\":[{\"BCO02ISID\":\"B\",\"BCO02CSNO\":\"81072537334\",\"BCO02CFTP\":\"101\",\"BCO02CFNO\":\"352229198804162681\",\"BCO02BOOL\":\"1\",\"BCO02NM5B\":\"陈光梅\",\"BCO02DATE1\":\"20150917\",\"BCO02DATE2\":\"20250917\",\"BCO02CNTY\":null,\"BCO02ISBU\":null,\"BCO02YE1B\":null,\"BCO02RS1B\":null,\"BCO02ST16\":\"  00000000000000\",\"BCO02BRNO1\":\"861059\",\"BCO02BRBM1\":null,\"BCO02STAF1\":\"8610710\",\"BCO02DATE3\":\"20121114\",\"BCO02STAM1\":\"2012-11-14-13.54.58.089000\",\"BCO02BRNO2\":\"861059\",\"BCO02BRBM2\":null,\"BCO02STAF2\":\"999AUTO\",\"BCO02DATE4\":\"20170627\",\"BCO02STAM2\":\"2016-12-14-16.14.34.535000\"}],\"AcctInfoList1\":[{\"BCO01ISID\":\"B\",\"BCO01CSNO\":\"81072537334\",\"BCO01BOOL\":\"1\",\"BCO01CSID\":\"101352229198804162681\",\"BCO01FLNM\":\"问米荣\",\"BCO01NM3B\":null,\"BCO01EN80\":null,\"BCO01CNTY\":\"156\",\"BCO01LANG\":\"C\",\"BCO01PTSN1\":\"01\",\"BCO01PTSN2\":\"02\",\"BCO01CSST\":null,\"BCO01VIPT\":\"2\",\"BCO01PTSN3\":\"02\",\"BCO01PTSN4\":\"03\",\"BCO01PTSN5\":null,\"BCO01PTSN6\":null,\"BCO01PTSN7\":null,\"BCO01PTSN8\":null,\"BCO01PTSN9\":null,\"BCO01BRNO1\":\"861151\",\"BCO01BRBM1\":null,\"BCO01STAF1\":null,\"BCO01NM201\":null,\"BCO01NM202\":null,\"BCO01NM40\":null,\"BCO01CU1B\":null,\"BCO01RS1B\":null,\"BCO01ST16\":\"1111000000000000\",\"BCO01BRNO2\":\"861059\",\"BCO01BRBM2\":null,\"BCO01STAF2\":\"8610710\",\"BCO01DATE1\":\"20121114\",\"BCO01STAM1\":\"2012-11-14-13.54.58.089000\",\"BCO01BRNO3\":\"861059\",\"BCO01BRBM3\":null,\"BCO01STAF3\":\"999AUTO\",\"BCO01DATE2\":\"20170627\",\"BCO01STAM2\":\"2016-12-14-16.14.34.535000\"}]}");
            output.setBody("{\"List\":[{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"626AUTO\",\"BBO01ANM20\":\"惠水恒升村镇批处理\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"8\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"8\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"8\",\"BBO01APWLV\":\"9\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"999000\",\"BBO01CBRNO\":\"999000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20061203\",\"BBO01BDATE\":\"20720527\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20061203\",\"BBO01AOPTS\":null,\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260002\",\"BBO01ANM20\":\"李驹\",\"BBO01ACFNO\":\"522731197409300032\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13765491988\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5111\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140123\",\"BBO01BDATE\":\"20640122\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20140124\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220527\",\"BBO01GDATE\":\"20140305\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260003\",\"BBO01ANM20\":\"陈昌华\",\"BBO01ACFNO\":\"522731197212020010\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13508547688\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\" ,\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140122\",\"BBO01BDATE\":\"20640121\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20170727\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260004\",\"BBO01ANM20\":\"程波\",\"BBO01ACFNO\":\"522731196904010062\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13765770298\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"1\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140122\",\"BBO01BDATE\":\"20241210\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220807\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220720\",\"BBO01GDATE\":\"20211025\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260005\",\"BBO01ANM20\":\"王勇\",\"BBO01ACFNO\":\"522731198006250055\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13708548983\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20160905\",\"BBO01BDATE\":\"20260905\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20160906\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220412\",\"BBO01GDATE\":\"20191015\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260009\",\"BBO01ANM20\":\"吴俊\",\"BBO01ACFNO\":\"522731198807200015\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15885465707\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5113\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140119\",\"BBO01BDATE\":\"20640118\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20140221\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220720\",\"BBO01GDATE\":\"20220515\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260011\",\"BBO01ANM20\":\"唐贵强\",\"BBO01ACFNO\":\"500233198802278147\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18722895960\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"3\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5113\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140122\",\"BBO01BDATE\":\"20640121\",\"BBO01ABLNO\":\"80018578\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220812\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":\"1\",\"BBO01AMSST\":null,\"BBO01DDATE\":\"20220704\",\"BBO01EDATE\":\"20220704\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220713\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260013\",\"BBO01ANM20\":\"陈俊廷\",\"BBO01ACFNO\":\"522731198212230012\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18585134348\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140122\",\"BBO01BDATE\":\"20640121\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20140123\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220721\",\"BBO01GDATE\":\"20201109\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260017\",\"BBO01ANM20\":\"潘堂品\",\"BBO01ACFNO\":\"52270119880918281X\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18286482019\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6116\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140118\",\"BBO01BDATE\":\"20231120\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20140309\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220721\",\"BBO01GDATE\":\"20220704\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260026\",\"BBO01ANM20\":\"花雄\",\"BBO01ACFNO\":\"522731199012139390\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18885463780\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20280603\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220622\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260028\",\"BBO01ANM20\":\"况金红\",\"BBO01ACFNO\":\"522731198602070026\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"15185486501\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6116\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260037\",\"BBO01ANM20\":\"苏盛涛\",\"BBO01ACFNO\":\"522731197011120015\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18684127239\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20280626\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20210924\",\"BBO01GDATE\":\"20191020\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260039\",\"BBO01ANM20\":\"罗吉槿\",\"BBO01ACFNO\":\"522729199008050025\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18375206269\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150703\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150704\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220719\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260048\",\"BBO01ANM20\":\"孙文\",\"BBO01ACFNO\":\"522731199308150038\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18886436950\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6114\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20161108\",\"BBO01BDATE\":\"20281108\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20161109\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260051\",\"BBO01ANM20\":\"汪华琴\",\"BBO01ACFNO\":\"522731199103102200\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18798008226\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6114\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170526\",\"BBO01BDATE\":\"20270526\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170527\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220722\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260053\",\"BBO01ANM20\":\"陈海丰\",\"BBO01ACFNO\":\"330304198211086938\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15988789030\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170606\",\"BBO01BDATE\":\"20270606\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220515\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220722\",\"BBO01GDATE\":\"20220321\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260060\",\"BBO01ANM20\":\"禹小燕\",\"BBO01ACFNO\":\"522731199211225240\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18985063854\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"1\",\"BBO01GBOOL\":\"2\",\"BBO01HBOOL\":\"2\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"6117\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"2\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"2\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20221205\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220531\",\"BBO01GDATE\":\"20220531\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260061\",\"BBO01ANM20\":\"黎人源\",\"BBO01ACFNO\":\"522731199310262549\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"15108549693\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5188\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260070\",\"BBO01ANM20\":\"周云惠\",\"BBO01ACFNO\":\"530426199712161022\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18085419474\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"1\",\"BBO01GBOOL\":\"2\",\"BBO01HBOOL\":\"2\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"6114\",\"BBO01ASTLE\":\"32\",\"BBO01APWLV\":\"32\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"2\",\"BBO01BFLAG\":\"2\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20200430\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626000\",\"BBO01ASTAF\":\"6260075\",\"BBO01ANM20\":\"黄国栋\",\"BBO01ACFNO\":\"330323197201201239\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13505870654\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"3\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"3\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"5111\",\"BBO01ASTLE\":\"36\",\"BBO01APWLV\":\"36\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626000\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200914\",\"BBO01BDATE\":\"20300914\",\"BBO01ABLNO\":\"80018494\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220818\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":\"1\",\"BBO01AMSST\":null,\"BBO01DDATE\":\"20210402\",\"BBO01EDATE\":\"20210402\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260007\",\"BBO01ANM20\":\"杨戈\",\"BBO01ACFNO\":\"52273119860128003X\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15185498340\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140108\",\"BBO01BDATE\":\"20251215\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150311\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220722\",\"BBO01GDATE\":\"20220125\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260020\",\"BBO01ANM20\":\"龙太艳\",\"BBO01ACFNO\":\"522731198707062188\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"15180870975\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20140118\",\"BBO01BDATE\":\"20640117\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20141017\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220720\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260024\",\"BBO01ANM20\":\"柴立静\",\"BBO01ACFNO\":\"52273119910507002X\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13885452212\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20250601\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220721\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260025\",\"BBO01ANM20\":\"高镭\",\"BBO01ACFNO\":\"522731199207212535\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15285328845\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20290514\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220714\",\"BBO01GDATE\":\"20220525\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260027\",\"BBO01ANM20\":\"张绚\",\"BBO01ACFNO\":\"522731199107014160\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18889281072\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7117\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150603\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150604\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220724\",\"BBO01GDATE\":\"20220724\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260030\",\"BBO01ANM20\":\"段国雄\",\"BBO01ACFNO\":\"522731198806042916\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18188548839\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7111\",\"BBO01ASTLE\":\"26\",\"BBO01APWLV\":\"26\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220614\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260032\",\"BBO01ANM20\":\"杨俊\",\"BBO01ACFNO\":\"522731198712065738\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18285484436\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7117\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"9\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260041\",\"BBO01ANM20\":\"揭燕荣\",\"BBO01ACFNO\":\"522731198708080038\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18685406412\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20151030\",\"BBO01BDATE\":\"20251030\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20151031\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20201123\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260050\",\"BBO01ANM20\":\"龙龙\",\"BBO01ACFNO\":\"522731199309170030\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15085140759\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170526\",\"BBO01BDATE\":\"20290515\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170527\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20191101\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260065\",\"BBO01ANM20\":\"张治航\",\"BBO01ACFNO\":\"522725199405151916\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15885432128\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220721\",\"BBO01GDATE\":\"20220721\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260069\",\"BBO01ANM20\":\"雷嵘旭\",\"BBO01ACFNO\":\"522731199410240013\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15723271024\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20200430\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220719\",\"BBO01GDATE\":\"20220622\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260079\",\"BBO01ANM20\":\"夏祺\",\"BBO01ACFNO\":\"522731199803140021\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18827029957\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"23\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6260081\",\"BBO01ANM20\":\"刘鹏程\",\"BBO01ACFNO\":\"522731199511090034\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18886480034\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"19\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6268001\",\"BBO01ANM20\":\"A1626110\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150519\",\"BBO01BDATE\":\"20250519\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150520\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6268002\",\"BBO01ANM20\":\"A2626110\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150519\",\"BBO01BDATE\":\"20250519\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150520\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6268003\",\"BBO01ANM20\":\"A3626110\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150519\",\"BBO01BDATE\":\"20250519\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150520\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626110\",\"BBO01ASTAF\":\"6268004\",\"BBO01ANM20\":\"F6261101\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20210222\",\"BBO01BDATE\":\"20310222\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20210223\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260031\",\"BBO01ANM20\":\"魏枭\",\"BBO01ACFNO\":\"522731199008100039\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18685311689\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20280604\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220428\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260036\",\"BBO01ANM20\":\"陈作云\",\"BBO01ACFNO\":\"330321196511158750\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13906640997\",\"BBO01ASTFP\":\"3\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7111\",\"BBO01ASTLE\":\"26\",\"BBO01APWLV\":\"26\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150626\",\"BBO01BDATE\":\"20251220\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150627\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260043\",\"BBO01ANM20\":\"陈德宇\",\"BBO01ACFNO\":\"522731199304200034\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"18885408541\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20160719\",\"BBO01BDATE\":\"20241220\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20210127\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20170804\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260047\",\"BBO01ANM20\":\"范进\",\"BBO01ACFNO\":\"522731198605240019\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13639059880\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20161108\",\"BBO01BDATE\":\"20261108\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20161109\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220711\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260058\",\"BBO01ANM20\":\"杨雯雯\",\"BBO01ACFNO\":\"522731199505160024\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13765444466\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260062\",\"BBO01ANM20\":\"龙青贤\",\"BBO01ACFNO\":\"522731199308102538\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15761204301\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"80018576\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20220525\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":\"2\",\"BBO01AMSST\":null,\"BBO01DDATE\":\"20181119\",\"BBO01EDATE\":\"20181119\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20171122\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260063\",\"BBO01ANM20\":\"陈朗\",\"BBO01ACFNO\":\"520102199012305815\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"13595433947\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20210220\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220422\",\"BBO01GDATE\":\"20181030\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260067\",\"BBO01ANM20\":\"龚双梅\",\"BBO01ACFNO\":\"522731199609289025\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18375201343\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"2\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220428\",\"BBO01GDATE\":\"20200513\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260068\",\"BBO01ANM20\":\"罗蒙\",\"BBO01ACFNO\":\"522731199209060045\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18185411520\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20170830\",\"BBO01BDATE\":\"20270830\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20170831\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220724\",\"BBO01GDATE\":\"20220724\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260071\",\"BBO01ANM20\":\"杨廷连\",\"BBO01ACFNO\":\"522730199107081746\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13885483658\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7117\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20200430\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"3\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260072\",\"BBO01ANM20\":\"韦翰涌\",\"BBO01ACFNO\":\"522731199505253618\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15285322251\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20200430\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220722\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260073\",\"BBO01ANM20\":\"陈秋风\",\"BBO01ACFNO\":\"522731199210216131\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"1\",\"BBO01ATELN\":\"15885403802\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20200429\",\"BBO01BDATE\":\"20300429\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20201030\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220506\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260077\",\"BBO01ANM20\":\"张小丽\",\"BBO01ACFNO\":\"522731199803063804\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18659459326\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"18\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260078\",\"BBO01ANM20\":\"吴懿博\",\"BBO01ACFNO\":\"522731199609290026\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"13312361564\",\"BBO01ASTFP\":\"1\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"1\",\"BBO01BBOOL\":\"0\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"1\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"1\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":\" 0\",\"BBO01ASPTN\":\"7125\",\"BBO01ASTLE\":\"11\",\"BBO01APWLV\":\"11\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"2\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220216\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":\"000\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6260080\",\"BBO01ANM20\":\"田霞霞\",\"BBO01ACFNO\":\"522731199803105744\",\"BBO01BCFNO\":null,\"BBO01ASEXX\":\"2\",\"BBO01ATELN\":\"18385495964\",\"BBO01ASTFP\":\"2\",\"BBO01ZBOOL\":\"1\",\"BBO01ACKIN\":\"2\",\"BBO01ABOOL\":\"0\",\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":\"0\",\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":\"0\",\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"2\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":\"7115\",\"BBO01ASTLE\":\"22\",\"BBO01APWLV\":\"22\",\"BBO01MBOOL\":\"1\",\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626110\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":\"1\",\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"1\",\"BBO01ASIST\":\"2\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20211214\",\"BBO01BDATE\":\"20261214\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20211215\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"20220725\",\"BBO01GDATE\":\"20220725\",\"BBO01ASN04\":\"8\",\"BBO01ASPST\":\"110\",\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6268005\",\"BBO01ANM20\":\"F6261201\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"4\",\"BBO01HBOOL\":\"1\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"4\",\"BBO01BFLAG\":\"1\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20210918\",\"BBO01BDATE\":\"20310918\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20210919\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6268101\",\"BBO01ANM20\":\"A1626120\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150730\",\"BBO01BDATE\":\"20250730\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150731\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null},{\"BBO01ABRNO\":\"626120\",\"BBO01ASTAF\":\"6268102\",\"BBO01ANM20\":\"A2626120\",\"BBO01ACFNO\":null,\"BBO01BCFNO\":null,\"BBO01ASEXX\":null,\"BBO01ATELN\":null,\"BBO01ASTFP\":\"7\",\"BBO01ZBOOL\":\"0\",\"BBO01ACKIN\":null,\"BBO01ABOOL\":null,\"BBO01BBOOL\":\"1\",\"BBO01CBOOL\":null,\"BBO01DBOOL\":null,\"BBO01EBOOL\":null,\"BBO01FBOOL\":\"0\",\"BBO01GBOOL\":\"1\",\"BBO01HBOOL\":\"4\",\"BBO01IBOOL\":null,\"BBO01JBOOL\":\"1\",\"BBO01AAUSP\":\"7\",\"BBO01KBOOL\":null,\"BBO01LBOOL\":null,\"BBO01APWFG\":null,\"BBO01ASPTN\":null,\"BBO01ASTLE\":\"7\",\"BBO01APWLV\":\"7\",\"BBO01MBOOL\":null,\"BBO01AFLAG\":\"1\",\"BBO01BFLAG\":\"4\",\"BBO01BBRNO\":\"626000\",\"BBO01CBRNO\":\"626120\",\"BBO01APTS1\":\"0\",\"BBO01DBRNO\":null,\"BBO01EBRNO\":null,\"BBO01APTSN\":null,\"BBO01BSTLE\":null,\"BBO01BPWLV\":null,\"BBO01ANO08\":null,\"BBO01BNO08\":null,\"BBO01AAVLS\":\"3\",\"BBO01ASIST\":\"1\",\"BBO01ASWKS\":\"1\",\"BBO01ASLKS\":\"1\",\"BBO01ADATE\":\"20150730\",\"BBO01BDATE\":\"20250730\",\"BBO01ABLNO\":\"0\",\"BBO01BPTSN\":null,\"BBO01CDATE\":\"20150731\",\"BBO01AOPTS\":\"1\",\"BBO01ACSTS\":null,\"BBO01AMSST\":null,\"BBO01DDATE\":\"0\",\"BBO01EDATE\":\"0\",\"BBO01FDATE\":\"0\",\"BBO01GDATE\":\"0\",\"BBO01ASN04\":\"1\",\"BBO01ASPST\":null,\"BBO01ARMRK\":null}]}");
            output.setRespData(responseData);
        }
//        System.out.println("handle success! " + "datetime: " + responseData.getReturnTime().getTime() + JSONObject.toJSONString(output));
        return output;
//        throw new SelfDefineException("input is invalid");
//        throw new RuntimeException();
    }

    @Override
    public StringOutput rpcInNewOutNewDapInOldOutOld(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        if (!equals){
            //处理失败
            output.setBody(JSON.toJSONString("business is failure !"));
        }else {
            //业务处理成功
            output.setBody(JSON.toJSONString("business is normal !"));
        }
        Map<String,String> map= Maps.newConcurrentMap();
        map.put("aaa","hello world !");
        System.out.println("handle success!");
        return output;
    }

    @Override
    public StringOutput rpcInNewOutNewDapInOldOutNew(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        if (!equals){
            //处理失败
            output.setBody(JSON.toJSONString("business is failure !"));
        }else {
            //业务处理成功
            output.setBody(JSON.toJSONString("business is normal !"));
        }
        Map<String,String> map= Maps.newConcurrentMap();
        map.put("aaa","hello world !");
        System.out.println("handle success!");
        return output;
    }

    @Override
    public StringOutput rpcInNewOutNewDapInNewOutOld(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        if (!equals){
            //处理失败
            output.setBody(JSON.toJSONString("business is failure !"));
        }else {
            //业务处理成功
            output.setBody(JSON.toJSONString("business is normal !"));
        }
        Map<String,String> map= Maps.newConcurrentMap();
        map.put("aaa","hello world !");
        System.out.println("handle success!");
        return output;
    }

    @Override
    public StringOutput rpcInNewOutNewDapInNewOutNew(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        if (!equals){
            //处理失败
            output.setBody(JSON.toJSONString("business is failure !"));
        }else {
            //业务处理成功
            output.setBody(JSON.toJSONString("business is normal !"));
        }
        Map<String,String> map= Maps.newConcurrentMap();
        map.put("aaa","hello world !");
        System.out.println("handle success!");
        return output;
    }

    @Override
    public StringOutput rpcInNewOutNewRpcInNewOutNew(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        if (!equals){
            //处理失败
            output.setBody(JSON.toJSONString("business is failure !"));
        }else {
            //业务处理成功
            output.setBody(JSON.toJSONString("business is normal !"));
        }
        Map<String,String> map= Maps.newConcurrentMap();
        map.put("aaa","hello world !");
        System.out.println("handle success!");
        return output;
//        throw new SelfDefineException("input is invalid");
//        throw new RuntimeException();
    }

    @Override
    public StringOutput rpcInNewOutNewRpcInNewOutNewParam(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        ResponseData responseData = new ResponseData();
        if (!equals) {
            //处理失败
            responseData.setCode("00000001");
            responseData.setMessage("失败");
            responseData.setServerIp("127.0.0.1");
            responseData.setReturnTime(new Date());
            responseData.setServcSeqNo("137egfd2387d27d832dgd7d276235423");
            responseData.setRecordCount(1000);
            responseData.setType("E");
            output.setBody(JSON.toJSONString("business is failure !"));
            output.setRespData(responseData);
        } else {
            //业务处理成功
            responseData.setCode("00000001");
            responseData.setMessage("成功");
            responseData.setServerIp("127.0.0.1");
            responseData.setReturnTime(new Date());
            responseData.setServcSeqNo("137egfd2387d27d832dgd7d276235423");
            responseData.setRecordCount(1000);
            responseData.setType("S");
            output.setBody(JSON.toJSONString("business is normal !"));
            output.setRespData(responseData);
        }
        System.out.println("handle success! " + "datetime: " + responseData.getReturnTime().getTime() + JSONObject.toJSONString(output));
        return output;
//        throw new SelfDefineException("input is invalid");
//        throw new RuntimeException();

    }
}
