package com.alipay.gateway.sofarpc.dubbo;

import com.alibaba.fastjson.JSON;
import com.alipay.gateway.facade.model.StringInput;
import com.alipay.gateway.facade.model.StringOutput;
import com.alipay.gateway.facade.model.User;
import com.alipay.gateway.facade.rpc.dubbo.TestDapRpcService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.google.common.collect.Maps;
import io.swagger.util.Json;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class TestDapRpcServiceImpl implements TestDapRpcService {
    @Override
    public StringOutput booleanParam(Boolean booleanParam) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal ! " + booleanParam);

        System.out.println("handle success ! " + booleanParam);
        return output;
    }

    @Override
    public StringOutput byteParam(Byte byteParam) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal ! " + byteParam);

        System.out.println("handle success! " + byteParam);
        return output;
    }

    @Override
    public StringOutput charParam(Character charParam) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal ! " + charParam);

        System.out.println("handle success ! " + charParam);
        return output;
    }

    @Override
    public StringOutput shortParam(Short shortParam) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal ! " + shortParam);

        System.out.println("handle success ! " + shortParam);
        return output;
    }

    @Override
    public StringOutput intParam(Integer intParam) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal ! " + intParam);

        System.out.println("handle success ! " + intParam);
        return output;
    }

    @Override
    public StringOutput longParam(Long longParam) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal !" + longParam);

        System.out.println("handle success ! " + longParam);
        return output;
    }

    @Override
    public StringOutput floatParam(Float floatParam) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal ! " + floatParam);

        System.out.println("handle success ! " + floatParam);
        return output;
    }

    @Override
    public StringOutput doubleParam(Double doubleParam) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal !" + doubleParam);

        System.out.println("handle success !" + doubleParam);
        return output;
    }

    @Override
    public StringOutput noParam() {
        StringOutput output = new StringOutput();
        output.setBody("business is normal !");

        System.out.println("handle success !");
        return output;
    }

    @Override
    public StringOutput userParam(User user) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal !" + user);

        System.out.println("handle success ! " + user);
        return output;
    }

    @Override
    public StringOutput inputParam(StringInput input) {
        // 获取和转换报文体
        String body = input.getBody();
       /* Map<String, String> bodyMap = (Map) JSON.parse(body);
        // 模拟业务处理
        String message = bodyMap.get("message");*/
        boolean equals = "hello world !".equals(body);
        //根据业务处理结果，返回响应
        StringOutput output = new StringOutput();
        if (!equals){
            //处理失败
            output.setBody(JSON.toJSONString("business is failure !"));
        }else {
            //业务处理成功
            output.setBody(JSON.toJSONString("business is normal !"));
        }
        Map<String,String> map= Maps.newConcurrentMap();
        map.put("aaa","hello world !");
        System.out.println("handle success!");
        return output;
    }

    @Override
    public StringOutput stringParam(String param) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal !" + param);

        System.out.println("handle success ! " + param);
        return output;
    }
}
