package com.alipay.gateway.sofarpc.dubbo;

import com.alipay.gateway.facade.model.User;
import com.alipay.gateway.facade.rpc.dubbo.TestDubboRpcService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class TestDubboRpcServiceImpl implements TestDubboRpcService {

    @Override
    public Map<String, String> booleanParam(Boolean booleanParam) {
        Map map = new HashMap();
        map.put("rpc_boolean", "hello " + booleanParam);
        return map;
    }

    @Override
    public Map<String, String> byteParam(Byte byteParam) {
        Map map = new HashMap();
        map.put("rpc_byte", "hello " + byteParam);
        return map;
    }

    @Override
    public Map<String, String> charParam(Character charParam) {
        Map map = new HashMap();
        map.put("rpc_char", "hello " + charParam);
        return map;
    }

    @Override
    public Map<String, String> shortParam(Short shortParam) {
        Map map = new HashMap();
        map.put("rpc_short", "hello " + shortParam);
        return map;
    }

    @Override
    public Map<String, String> intParam(Integer intParam) {
        Map map = new HashMap();
        map.put("rpc_int", "hello " + intParam);
        return map;
    }

    @Override
    public Map<String, String> longParam(Long longParam) {
        Map map = new HashMap();
        map.put("rpc_long", "hello " + longParam);
        return map;
    }

    @Override
    public Map<String, String> floatParam(Float floatParam) {
        Map map = new HashMap();
        map.put("rpc_float", "hello " + floatParam);
        return map;
    }

    @Override
    public Map<String, String> doubleParam(Double doubleParam) {
        Map map = new HashMap();
        map.put("rpc_double", "hello " + doubleParam);
        return map;
    }

    @Override
    public Map<String, String> noParam() {
        Map map = new HashMap();
        map.put("rpc_zym", "hello");
        return map;
    }

    @Override
    public User userParam(User user) {
        return user;
    }

    public Map<String, String> stringParam(String param) {
        Map map = new HashMap();
        map.put("rpc_string", "hello " + param);
        return map;
    }
}
