package com.alipay.gateway.sofarpc.triple;

import com.alibaba.fastjson.JSONObject;
import com.alipay.gateway.facade.model.User;
import com.alipay.gateway.facade.rpc.triple.SofaBootApigw2SofagwHessian2Uid;
import com.alipay.gateway.facade.rpc.triple.TripleHessian2Uid;
import com.alipay.sofa.runtime.api.annotation.SofaParameter;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Author 蕖兰
 * @Date 2021/11/12 5:22 下午
 * @Description
 */
@Service
@SofaService(bindings = {@SofaServiceBinding(
                            bindingType = "tri",
                            serializeType = "hessian2",
                            timeout = 60000,
                            parameters = {@SofaParameter(key = "triple.use.old.path", value = "true")})},
            uniqueId = "com.test.unique.id")
public class TripleHessian2UidImpl implements TripleHessian2Uid {

    @Override
    public String hello() {
        return "currentTimeMillis: " + System.currentTimeMillis();
    }

    @Override
    public Map<String, String> noParamForMap() {
        Map<String, String> map = new HashMap<>();
        map.put("xiaohei", "13");
        map.put("xiaobai", "14");
        return map;
    }

    @Override
    public String simpleParam(String str) {
        return "hello " + str + ", currentTimeMillis: " + System.currentTimeMillis();
    }

    @Override
    public Map<String, String> simpleParamForMap(String str) {
        Map<String, String> map = new HashMap<>();
        map.put(str, "13");
        map.put("xiaobai", "14");
        return map;
    }

    @Override
    public String jsonParam(JSONObject json) {
        return "xiaobai:" + json.get("xiaobai") + ",xiaohei:" + json.get("xiaohei");
    }

    @Override
    public Map<String, String> jsonParamForMap(JSONObject json) {
        int xiaoheiAge = (int) json.get("xiaohei");
        int xiaobaiAge = (int) json.get("xiaobai");

        Map<String, String> map = new HashMap<>();
        map.put("xiaohei", xiaoheiAge + "");
        map.put("xiaobai", xiaobaiAge + "");
        return map;
    }

    @Override
    public List<String> listNoParam() {
        return Arrays.asList("xiaobai", "xiaohei");
    }

    @Override
    public List<User> listSimpleParam(List<User> list) {
        User u1 = new User("xiaohei", list.get(0).getAge());
        User u2 = new User("xiaobai", list.get(1).getAge());
        List<User> list2 = new ArrayList<>();
        list2.add(u1);
        list2.add(u2);

        return list2;
    }
}
