/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.facade.rest.nosign;

import com.alipay.gateway.facade.model.User;
import com.alipay.sofa.gateway.api.filter.jax.NeedSign;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;

/**
 * @author wb-hzb742209
 * @date 2020年12月2日 下午6:59:04
 */
@Path("rest")
public interface SofaRestPutService {
    @PUT
    @Path("noParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String noParam();

    @PUT
    @Path("sampleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String sampleParam(String param);

    @PUT
    @Path("param/{uid}")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String uidParam(@PathParam("uid") String uid);

    @PUT
    @Path("moreParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String moreParam(@QueryParam("param") String param, @HeaderParam("param1") String param1, String param2);

    @PUT
    @Path("headerParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> headerParam(HttpServletRequest request);

    @PUT
    @Path("jsonParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, Object> jsonParam(@RequestBody User user);

    @PUT
    @Path("formParam")
    @Produces(MediaType.APPLICATION_FORM_URLENCODED)
    @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
    Map<String, Object> formParam(@FormParam("name") String name, @FormParam("age") String age);

    @PUT
    @Path("timeout")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String timeout(String sleepTime);

    @PUT
    @Path("exception")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    void exception() throws Exception;

    @PUT
    @Path("hello")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> hello();

    @PUT
    @Path("objectNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectNoParam();

    @PUT
    @Path("objectSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectSimpleParam(User user);

    @PUT
    @Path("mapNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> mapNoParam();

    @PUT
    @Path("mapSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, User> mapSimpleParam(Map<String, User> map);

    @PUT
    @Path("listNoParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<String> listNoParam();

    @PUT
    @Path("listSimpleParam")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<User> listSimpleParam(List<User> list);

    @PUT
    @Path("getApiParam3")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String getApiParam3(String param);
}