/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.facade.rest.sign;

import com.alipay.gateway.facade.model.*;
import com.alipay.sofa.gateway.api.filter.jax.NeedSign;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;

/**
 * @author wb-hzb742209
 * @date 2020年12月2日 下午6:59:04
 */
@Path("v2")
public interface ApiflowRestSignPostService {
    @POST
    @Path("getTourist")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Tourist getTourist(String idCard);

    @POST
    @Path("getPoint")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Point jsonParam(Point point);

    @POST
    @Path("getShip")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Ship jsonParam(Ship ship);

    @POST
    @Path("noParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String noParam();

    @POST
    @Path("sampleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String sampleParam(String param);

    @POST
    @Path("param/{uid}")
    @NeedSign
    String uidParam(@PathParam("uid") String uid);

    @POST
    @Path("moreParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String moreParam(@CookieParam("param") String param, @HeaderParam("param1") String param1, String param2);

    @POST
    @Path("headerParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> headerParam(HttpServletRequest request);

    @POST
    @Path("jsonParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, Object> jsonParam(@RequestBody User user);

    @POST
    @Path("formParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_FORM_URLENCODED)
    @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
    Map<String, Object> formParam(@FormParam("name") String name, @FormParam("age") String age);

    @POST
    @Path("timeout")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String timeout(String sleepTime);

    @POST
    @Path("exception")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    void exception() throws Exception;

    @POST
    @Path("auth")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    AuthResponse auth(AuthRequest authRequest);

    @POST
    @Path("hello")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> hello();

    @POST
    @Path("objectNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectNoParam();

    @POST
    @Path("objectSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectSimpleParam(User user);

    @POST
    @Path("mapNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> mapNoParam();

    @POST
    @Path("mapSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, User> mapSimpleParam(Map<String, User> map);

    @POST
    @Path("listNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<String> listNoParam();

    @POST
    @Path("listSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<User> listSimpleParam(List<User> list);



    @POST
    @Path("getApiParam2")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String getApiParam2(String param);

    @POST
    @Path("getApiParam3")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String getApiParam3(String param);

    @POST
    @Path("getApiParam3Sign")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String getApiParam3Sign(@HeaderParam("param") String param);
}