/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.facade.rest.sign;

import com.alipay.gateway.facade.model.User;
import com.alipay.sofa.gateway.api.filter.jax.NeedSign;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;

/**
 * @author wb-hzb742209
 * @date 2020年12月2日 下午6:59:04
 */
@Path("v2")
public interface SofaRestSignDeleteService {
    @DELETE
    @Path("noParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String noParam();

    @DELETE
    @Path("sampleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String sampleParam(@QueryParam("param") String param);

    @DELETE
    @Path("param/{uid}")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String uidParam(@PathParam("uid") String uid);

    @DELETE
    @Path("moreParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String moreParam(@QueryParam("param") String param, @HeaderParam("param1") String param1, @QueryParam("param2") String param2);

    @DELETE
    @Path("headerParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> headerParam(HttpServletRequest request);

    @DELETE
    @Path("jsonParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, Object> jsonParam(User user);

    @DELETE
    @Path("timeout")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String timeout(@QueryParam("sleepTime") String sleepTime);

    @DELETE
    @Path("exception")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    void exception() throws Exception;

    @DELETE
    @Path("hello")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> hello();

    @DELETE
    @Path("objectNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectNoParam();

    @DELETE
    @Path("objectSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectSimpleParam(User user);

    @DELETE
    @Path("mapNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> mapNoParam();

    @DELETE
    @Path("mapSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, User> mapSimpleParam(Map<String, User> map);

    @DELETE
    @Path("listNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<String> listNoParam();

    @DELETE
    @Path("listSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<User> listSimpleParam(List<User> list);
}