/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.facade.rest.sign;

import com.alipay.gateway.facade.model.AuthRequest;
import com.alipay.gateway.facade.model.AuthResponse;
import com.alipay.gateway.facade.model.User;
import com.alipay.sofa.gateway.api.filter.jax.NeedSign;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;

/**
 * @author wb-hzb742209
 * @date 2020年12月7日 下午8:35:04
 */
@Path("v2")
public interface SofaRestSignGetService {
    @GET
    @Path("noParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String noParam();

    @GET
    @Path("sampleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String sampleParam(@QueryParam("param") String param);

    @GET
    @Path("param/{uid}")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String uidParam(@PathParam("uid") String uid);

    @GET
    @Path("moreParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String moreParam(@QueryParam("param") String param, @HeaderParam("param1") String param1, @QueryParam("param2") String param2);

    @GET
    @Path("headerParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> headerParam(HttpServletRequest request);

    @GET
    @Path("jsonParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, Object> jsonParam(User user);

    @GET
    @Path("timeout")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    String timeout(@QueryParam("sleepTime") String sleepTime);

    @GET
    @Path("exception")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    void exception() throws Exception;

    @GET
    @Path("auth")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    AuthResponse auth(AuthRequest authRequest);

    @GET
    @Path("hello")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> hello();

    @GET
    @Path("objectNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectNoParam();

    @GET
    @Path("objectSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    User objectSimpleParam(User user);

    @GET
    @Path("mapNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, String> mapNoParam();

    @GET
    @Path("mapSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    Map<String, User> mapSimpleParam(Map<String, User> map);

    @GET
    @Path("listNoParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<String> listNoParam();

    @GET
    @Path("listSimpleParam")
    @NeedSign
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    List<User> listSimpleParam(List<User> list);
}