/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.facade.util;

import com.alibaba.fastjson.JSON;
import com.alipay.gateway.facade.model.AuthRequest;
import com.alipay.gateway.facade.model.AuthResponse;
import com.alipay.gateway.facade.model.ByteAuthResponse;
import com.alipay.gateway.facade.model.ObjectAuthResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengfan(shuming)
 * @version $Id: AuthUtil.java, v 0.1 2020年07月24日 8:44 PM chengfan(shuming) Exp $
 */
public class AuthUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUtil.class);

    public static AuthResponse buildAuthRes(AuthRequest request) {
        String oldVersion = request.getContext().get("oldVersion");
        AuthResponse response = StringUtils.equalsIgnoreCase("true", oldVersion) ? new ByteAuthResponse() :
                new ObjectAuthResponse();
        String headerKey = request.getContext().get("headerKey");
        String path = request.getContext().get("x-mosn-path");
        String method = request.getContext().get("x-mosn-method");
        String bodyKey = request.getContext().get("bodyKey");
        String queryKey = request.getContext().get("queryKey");
        LOGGER.info("headerKey:" + headerKey + ",bodyKey:" + bodyKey + ",queryKey:" + queryKey + ",path:" + path + ",method:" + method);
        if ("h".equalsIgnoreCase(headerKey)) {
            // success
            response.setSuccess(true);

            Map<String, String> principal = new HashMap<>();
            principal.put("param-to-server", "abc");
            principal.put("userName", "user name is tom aaa");
            response.setPrincipal(principal);
            return response;

        } else {
            // error
            response.setSuccess(false);
            Map<String, String> failResponseHeader = new HashMap<>();
            queryKey = request.getContext().get("queryKey");
            if ("q".equalsIgnoreCase(queryKey)) {
                failResponseHeader.put("header-to-client", "query");
            } else {
                failResponseHeader.put("header-to-client", "no-query");
            }
            response.setFailResponseHeader(failResponseHeader);
            Map<String, String> failResponseBody = new HashMap<>();
            String context = JSON.toJSONString(request.getContext());
//            if (bodyKey.equalsIgnoreCase("b")) {
//                failResponseBody.put("body-to-client", "b");
//            } else {
//                failResponseBody.put("body-to-client", "no-b");
//            }
            failResponseBody.put("test", context);
            response.setFailResponse(failResponseBody);
            response.setFailResponseStatus(401);
            LOGGER.info("buildAuthRes|response|{}|{}", (response instanceof ByteAuthResponse), JSON.toJSONString(response));
            return response;
        }
    }

    public static AuthResponse buildAuthRes1(AuthRequest request) {
        String oldVersion = request.getContext().get("oldVersion");
        AuthResponse response = StringUtils.equalsIgnoreCase("true", oldVersion) ? new ByteAuthResponse() :
                new ObjectAuthResponse();
        String headerKey = request.getContext().get("headerKey");
        String bodyKey = request.getContext().get("body.bodyKey");
//        String bodyKey = request.getContext().get("bodyKey.a.b");
        String queryKey = request.getContext().get("queryKey");
        String cookieKey = request.getContext().get("cookieKey");

        if ("test".equalsIgnoreCase(headerKey) && "cookie".equalsIgnoreCase(cookieKey)) {
            // success
            response.setSuccess(true);
            Map<String, String> principal = new HashMap<>();
            principal.put("param-to-server", "buildAuthRes1");
            response.setPrincipal(principal);
            return response;
        } else {
            // error
            response.setSuccess(false);

            Map<String, String> failResponseHeader = new HashMap<>();
            if ("q".equalsIgnoreCase(queryKey)) {
                failResponseHeader.put("header-to-client", headerKey);
                failResponseHeader.put("query-to-client", queryKey);
                failResponseHeader.put("cookie-to-client", cookieKey);
            } else {
                failResponseHeader.put("header-to-client", "no-header");
                failResponseHeader.put("query-to-client", "no-query");
                failResponseHeader.put("cookie-to-client", "no-cookie");
            }
            response.setFailResponseHeader(failResponseHeader);
            Map<String, String> failResponseBody = new HashMap<>();
            String context = JSON.toJSONString(request.getContext());
            if ("bk".equalsIgnoreCase(bodyKey)) {
                failResponseBody.put("body-to-client", "bk");
            } else {
                failResponseBody.put("body-to-client", "no-bk");
            }

            failResponseBody.put("context", context);
            failResponseBody.put("body", JSON.toJSONString(bodyKey));
//            1.11之后的版本
            response.setFailResponse(failResponseBody);
            response.setFailResponseStatus(500);

            return response;
        }
    }
}