/**
 * Alipay.com Inc. Copyright (c) 2004-2021 All Rights Reserved.
 */
package com.alipay.immune.model.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 列表查询的标准返回
 * @author llhuan.lh
 * @version $Id: SelectResult.java, v 0.1 2021年03月29日 5:13 PM llhuan.lh Exp $
 */
public class SelectResult<T> extends Result<T> implements Serializable {

    private static final long serialVersionUID = -7971014241432170865L;

    /**
     * 列表查询到总数
     */
    private Integer totalCnt = 0;

    /**
     * 数据列表
     */
    private List<T> dataList = new ArrayList<>();

    /**
     * default Constructor
     */
    public SelectResult() {
        super();
    }

    /**
     * constructor 1
     *
     * @param success
     * @param msg
     * @param errorCode
     */
    public SelectResult(Boolean success, String msg, String errorCode) {
        super(success, msg, errorCode);
    }

    /**
     * constructor 2
     * @param dataList
     */
    public SelectResult(List<? extends T> dataList){
        super(true);
        this.dataList = (List<T>) dataList;
    }

    /**
     * Getter method for property <tt>totalCnt</tt>.
     *
     * @return property value of totalCnt
     */
    public Integer getTotalCnt() {
        return totalCnt;
    }

    /**
     * Setter method for property <tt>totalCnt</tt>.
     *
     * @param totalCnt value to be assigned to property totalCnt
     */
    public void setTotalCnt(Integer totalCnt) {
        this.totalCnt = totalCnt;
    }

    /**
     * Getter method for property <tt>dataList</tt>.
     *
     * @return property value of dataList
     */
    public List<T> getDataList() {
        return dataList;
    }

    /**
     * Setter method for property <tt>dataList</tt>.
     *
     * @param dataList value to be assigned to property dataList
     */
    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

}