/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2020 All Rights Reserved.
 */
package com.alipay.gateway.common;

import com.alipay.sofa.gateway.api.domain.ApiSecretKey;
import com.alipay.sofa.gateway.api.filter.http.ApiServletSignFilter;
import com.alipay.sofa.rpc.config.JAXRSProviderManager;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author chengfan(shuming)
 * @version $Id: Config.java, v 0.1 2020年04月16日 7:03 PM chengfan(shuming) Exp $
 */
@Configuration
public class Config {
    @Bean
    public FilterRegistrationBean filterRegistrationBean(@Value("${pub.app.accessKey}") String keyId,
                                                         @Value("${pub.app.secretKey}") String secretKey) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(apiServletSignFilter(keyId, secretKey));
        registration.addUrlPatterns("/*"); // filter生效的uri路径，表示对所有路径生效
        registration.setName("apiServletSignFilter");
        registration.setOrder(Ordered.HIGHEST_PRECEDENCE);
        return registration;
    }

    @Bean
    public ApiServletSignFilter apiServletSignFilter(@Value("${pub.app.accessKey}") String keyId,
                                                     @Value("${pub.app.secretKey}") String secretKey
    ) {
        ApiSecretKey apiSecretKey = new ApiSecretKey(keyId, secretKey);
        ApiServletSignFilter filter = new ApiServletSignFilter();
        List<ApiSecretKey> secretKeys = new ArrayList<>();
        secretKeys.add(apiSecretKey);
        filter.setApiSecretKeys(secretKeys);
        filter.setCheckSign(true);
        filter.setSignUriRegex("/springmvc/test/sign/.*"); // 开启验签加签的uri路径，表示对 /j 开头的路径做加签验签，其他路径则不验签
        return filter;
    }

    // 给 rest 服务添加filter
    @Bean
    public CustomApiRestSignFilter apiRestSignFilter(@Value("${pub.app.rest.accessKey}") String keyId,
                                               @Value("${pub.app.rest.secretKey}") String secretKey) {
        ApiSecretKey apiSecretKey = new ApiSecretKey(keyId, secretKey);
        List<ApiSecretKey> secretKeys = new ArrayList<>();
        secretKeys.add(apiSecretKey);
        CustomApiRestSignFilter filter = new CustomApiRestSignFilter();
        filter.setApiSecretKeys(secretKeys);
        filter.setCheckSign(true);
        List<String> urlTemplates = Lists.newArrayList();
        urlTemplates.add("/v2/.*");
        filter.setUriTemplates(urlTemplates);
        JAXRSProviderManager.registerCustomProviderInstance(filter);
        return filter;
    }
}