package com.alipay.gateway.controller.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.gateway.facade.model.StringInput;
import com.alipay.gateway.facade.model.StringOutput;
import com.alipay.gateway.facade.model.User;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Author 蕖兰
 * @Date 2021/11/16 7:16 下午
 * @Description TODO
 */
public class HttpBaseService {

    @Value("${gateway.test.weight.router.tag:aaa}")
    private String httpRouterTag;

    private static final Logger LOGGER = LoggerFactory.getLogger(HttpBaseService.class);

    public Map<String, String> hello() {
        Map<String, String> map = new HashMap<>();
        map.put("hello", "sofastack");
        return map;
    }

    public String simpleParam(String param) {
        return "hello " + param;
    }

    public Map<String, String> simpleParamForMap(String param) {
        Map<String, String> map = Maps.newHashMap();
        map.put("result", "hello " + param);
        return map;
    }

    public String routerweight() {
        return httpRouterTag;
    }

    public Map<String, Object> routerweightRpc2Http() {
        Map<String, Object> map = Maps.newHashMap();
        map.put("hello", httpRouterTag);
        return map;
    }

    public Integer intParam(Integer param) {
        return param;
    }

    public Map<String, String> multiParam(String param1, String param2) {
        Map<String, String> map = new HashMap<>();
        map.put("result", "hello " + param1 + " ---> " + param2);
        return map;
    }

    public Map<String, String> multiParamList(List<String> params) {
        Map<String, String> map = new HashMap<>();
        if (params.size() > 0) {
            map.put("getParam1", params.get(0));
        }
        if (params.size() > 1) {
            map.put("getParam2", params.get(1));
        }
        return map;
    }


    public Map<String, String> pathParam(String uid) {
        Map<String, String> map = new HashMap<>();
        map.put("get_uid", uid);
        return map;
    }

    public User jsonParam(User user) {
        return user;
    }


    public Map<String, String> withHeader(HttpServletRequest request, String name) {
        Map<String, String> map = Maps.newHashMap();
        String uid = request.getHeader("uid_of_header");
//        String name = request.getParameter("name");

        Cookie[] cookies = request.getCookies();
        for (Cookie cookie : cookies) {
            String key = cookie.getName();
            String value = cookie.getValue();
            map.put(key, value);
        }
        map.put("uid", uid);
        map.put("name", name);
        return map;
    }

    private List<String> getHeaders(Enumeration<String> headerNames) {
        List<String> headers = new ArrayList<>();
        while (headerNames.hasMoreElements()) {
            headers.add(headerNames.nextElement());
        }
        return headers;
    }


    public Map<String, Object> moreParam(String param, String userName, String age) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("param", param);
        map.put("userName", userName);
        map.put("age", age);
        return map;
    }


    public Map<String, String> timeout(String param) {
        try {
            if(LOGGER.isInfoEnabled()) {
                LOGGER.info("test-timeout:{}", param);
            }
            long value = Long.parseLong(param);
            Thread.sleep(value);
            Map<String, String> map = Maps.newHashMap();
            map.put("time", param);
            if(LOGGER.isInfoEnabled()) {
                LOGGER.info("test-timeout-end:{}", param);
            }
            return map;
        } catch (Exception e) {
            Map<String, String> map = Maps.newHashMap();
            map.put("errorMessage", e.getMessage());
            return map;
        }
    }

    public Map<String, String> cache(String param) {
        Map<String, String> map = new HashMap<>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        map.put("result", " " + df.format(System.currentTimeMillis()));
        return map;
    }


    public Map<String, String> authBodyParam(String param, HttpServletRequest request) {
        Map<String, String> map = new HashMap<>();
        System.out.println(request.getHeader("userName"));
        map.put("result", "hello " + param + request.getHeader("userName"));
        return map;
    }


    public List<JSONObject> requestParamMapping(HttpServletRequest request, List<JSONObject> jsonObject) {
        Enumeration<String> names = request.getHeaderNames();
        JSONObject jsonObject1 = new JSONObject();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            jsonObject1.put(name, request.getHeader(name));
        }
        if (jsonObject == null) {
            jsonObject = new ArrayList<>();
        }
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("header", jsonObject1);
        jsonObject.add(jsonObject2);
        return jsonObject;
    }

    public JSONObject responseParamMapping(HttpServletRequest request, List<JSONObject> jsonObject) {
        Enumeration<String> names = request.getHeaderNames();
        JSONObject jsonObject1 = new JSONObject();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            jsonObject1.put(name, request.getHeader(name));
        }
        JSONObject res = new JSONObject();
        res.put("temp", request.getHeader("temp"));
        res.put("x", "&&&&");
        res.put("y", "%%%%");
        res.put("header", jsonObject1);
        res.put("body", jsonObject);
        return res;
    }

    public Map<String, Object> ldc(HttpServletResponse response, HttpServletRequest request) {
        Map<String, Object> map = new HashMap<>();
        map.put("reqHeaderName", getHeaders(request.getHeaderNames()));
        map.put("reqCookies", request.getCookies());
        map.put("ip", getHost());
        return map;
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            return "x.x.x.x";
        }
    }

    public Object objectNoParam() {
        return new User("tom", 12);
    }


    public Object objectSimpleParam(User user) {
        return user;
    }

    public Map<String, String> mapNoParam() {
        Map<String, String> map = new HashMap<>();
        map.put("map", "noParam");
        return map;
    }

    public Map<String, User> mapSimpleParam(Map<String, User> map) {
        return map;
    }

    public List<String> listNoParam() {
        List<String> list = new ArrayList<>();
        list.add("aaa");
        return list;
    }

    public List<User> listSimpleParam(List<User> list) {
        return list;
    }

    public StringOutput inputParam(StringInput input) {
        StringOutput output = new StringOutput();
        output.setBody("business is normal !" + JSON.toJSONString(input));

        System.out.println("handle success ! " + JSON.toJSONString(input));
        return output;
    }

}
