package com.alipay.gateway.sofarpc;

import com.alibaba.fastjson.JSONObject;
import com.alipay.gateway.facade.model.Account;
import com.alipay.gateway.facade.model.AccountQueryResult;
import com.alipay.gateway.facade.model.User;
import com.alipay.gateway.facade.rpc.GatewayRpcService;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author 蕖兰
 * @Date 2021/11/12 5:22 下午
 * @Description
 */
@Service
@SofaService(bindings = {@SofaServiceBinding(bindingType = "bolt")}, uniqueId = "rpc-test-1112")
public class GatewayRpcServiceImpl implements GatewayRpcService {

    @Override
    public String hello() {
        return "hello noParamForString";
    }

    @Override
    public void testVoid(String param) {

    }

    @Override
    public void testException() throws Exception {

    }

    @Override
    public Map<String, String> noParamForMap() {
        System.out.println("rpc-test");
        Map<String, String> map = Maps.newHashMap();
        map.put("result", "noParamForMap");
        return map;
    }

    @Override
    public String simpleParam(String param) {
        return "hello simpleParamForString " + param;
    }

    @Override
    public Map<String, String> simpleParamForMap(String param) {
        Map<String, String> map = Maps.newHashMap();
        map.put("result", "simpleParamForMap " + param);
        return map;
    }

    @Override
    public String jsonParam(JSONObject param) {
        return "hello jsonParam";
    }

    @Override
    public Map<String, String> jsonParamForMap(JSONObject param) {
        Map<String, String> map = Maps.newHashMap();
        map.put("result", "jsonParamForMap");
        return map;
    }

    @Override
    public User jsonParamForUser(User user) {
        return user;
    }

    @Override
    public List<String> listNoParam() {
        List<String> list = new ArrayList<>();
        list.add("aaa");
        return list;
    }

    @Override
    public List<User> listSimpleParam(List<User> list) {
        return list;
    }

    @Override
    public String registryQuestionTest() throws UnknownHostException {
        return JSONObject.toJSONString(InetAddress.getLocalHost());
    }

    @Override
    public User user1(User user) {
        return user;
    }

    @Override
    public User user2(String name) {
        User user = new User(name, 20);
        return user;
    }

    @Override
    public AccountQueryResult queryAccountBalance(String accountNo) {

        AccountQueryResult accountQueryResult = new AccountQueryResult();
        Account account = new Account(accountNo, new BigDecimal(11111111), new BigDecimal(22222222), new BigDecimal(33333333));
        accountQueryResult.setSuccess(true);
        accountQueryResult.setAccount(account);
        accountQueryResult.setMsgCode("200");
        accountQueryResult.setMsgText("success");

        return accountQueryResult;
    }
}
