import argparse
import math
import cv2
from typing import List
import numpy as np
import urllib.request
#背景变换
def change_background_demo(
        args: List[str],
) -> None:
    assert (args.param is not None and len(args.param) > 3), "parameters wrong, use -h for details!"
    of_file = args.param[3]
    [sc_image, seg_img, bg_image] = [cv2.imread(img_file, cv2.IMREAD_UNCHANGED)
                            for img_file in args.param[0:3]]
    # 将分割结果进行新背景融合
    rst_image = image_merge_background(sc_image, seg_img, bg_image)
    # 保存结果到本地
    cv2.imwrite(of_file, rst_image)
#分割后的图合并到背景图中
def image_merge_background(sc_image, png_image, bg_image):
    assert (sc_image is not None and png_image is not None and bg_image is not None), "read image input error!"
    h, w, c = sc_image.shape
    # keep sc_image, png_image and bg_image same size
    viapi_image = cv2.resize(png_image, (w, h))
    bg_image = cv2.resize(bg_image, (w, h))
    if len(viapi_image.shape) == 2:
        mask = viapi_image[:, :, np.newaxis]
    elif viapi_image.shape[2] == 4:
        mask = viapi_image[:, :, 3:4]
    elif viapi_image.shape[2] == 3:
        mask = viapi_image[:, :, 0:1]
    else:
        raise Exception("invalid image mask!")
    mask = mask / 255.0
    # merge background（合并背景）
    sc_image = sc_image.astype(float)
    bg_image = bg_image.astype(float)
    rst_image = (sc_image - bg_image) * mask + bg_image
    rst_image = np.clip(rst_image, 0, 255)
    return rst_image
def define_options():
    parser = argparse.ArgumentParser(description='Human segmentation examples.')
    parser.add_argument('-p', '--param', nargs=4
                            , default=['./data/source.jpg', './data/output.png', './data/background.jpg', 'result.jpg']
                            , type=str
                            , help=('source_image_path output_image_path background_path result_path'))
    args = parser.parse_args()
    return args
if __name__ == '__main__':
    args = define_options()
    change_background_demo(args)