#!/bin/bash
if [ $# -lt 1 ]; then
  echo "please assign path, eg: ./copy_android_so_from.sh shichen.fsc@11.164.63.77:/home/shichen.fsc/code/public/nui/out/Android"
  exit
fi
detail_path=$1
echo $detail_path

mkdir -p arm64-v8a
arm64_remote=$detail_path/arm64-v8a/lib
echo "scp arm64-v8a libneonui_shared.so ......"
scp $arm64_remote/libneonui_shared.so ./arm64-v8a/libneonui_shared.so
echo "Done"

echo "scp arm64-v8a libneonuijni.so ......"
scp $arm64_remote/libneonuijni.so ./arm64-v8a/libneonuijni_public.so
echo "Done"


mkdir -p armeabi-v7a
armv7_remote=$detail_path/armeabi-v7a/lib
echo "scp armeabi-v7a libneonui_shared.so ......"
scp $armv7_remote/libneonui_shared.so ./armeabi-v7a/libneonui_shared.so
echo "Done"
echo "scp armeabi-v7a libneonuijni.so ......"
scp $armv7_remote/libneonuijni.so ./armeabi-v7a/libneonuijni_public.so
echo "Done"


mkdir -p x86
x86_remote=$detail_path/x86/lib
echo "scp x86 libneonui_shared.so ......"
scp $x86_remote/libneonui_shared.so ./x86/libneonui_shared.so
echo "Done"
echo "scp x86 libneonuijni.so ......"
scp $x86_remote/libneonuijni.so ./x86/libneonuijni_public.so
echo "Done"


mkdir -p x86_64
x86_64_remote=$detail_path/x86_64/lib
echo "scp x86_64 libneonui_shared.so ......"
scp $x86_64_remote/libneonui_shared.so ./x86_64/libneonui_shared.so
echo "Done"
echo "scp x86_64 libneonuijni.so ......"
scp $x86_64_remote/libneonuijni.so ./x86_64/libneonuijni_public.so
echo "Done"
