package org.example;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.resps.Tuple;

public class GameRankSample {

    static int TOTAL_SIZE = 20;

    public static void main(String[] args) {
        // 连接地址，可通过Redis控制台获取。
        String host = "r-bp************ypd.redis.rds.aliyuncs.com";

        int port = 6379;
        Jedis jedis = new Jedis(host, port);
        try {
            // 实例密码。
            String authString = jedis.auth("Da*******23"); //password
            if (!authString.equals("OK")) {
                System.err.println("AUTH Failed: " + authString);
                return;
            }
            // Key（键）
            String key = "Game name: Keep Running, Alibaba Cloud!";
            // 清除可能的已有数据。
            jedis.del(key);
            // 模拟生成若干个游戏玩家。
            List<String> playerList = new ArrayList<String>();
            for (int i = 0; i < TOTAL_SIZE; ++i) {
                // 为每个玩家随机生成一个ID。
                playerList.add(UUID.randomUUID().toString());
            }
            System.out.println("Inputs all players ");
            // 记录每个玩家的得分。
            for (int i = 0; i < playerList.size(); i++) {
                // 随机生成数字，模拟玩家的游戏得分。
                int score = (int) (Math.random() * 5000);
                String member = playerList.get(i);
                System.out.println("Player ID:" + member + ", Player Score: " + score);
                // 将玩家ID和分数添加到相应键的SortedSet中。
                jedis.zadd(key, score, member);
            }
            // 输出打印全部玩家排行榜。
            System.out.println();
            System.out.println("       " + key);
            System.out.println(" Ranking list of all players");
            // 从对应key的SortedSet中获取已经排好序的玩家列表。
            List<Tuple> scoreList = jedis.zrevrangeWithScores(key, 0, -1);
            for (Tuple item : scoreList) {
                System.out.println(
                        "Player ID:" +
                                item.getElement() +
                                ", Player Score:" +
                                Double.valueOf(item.getScore()).intValue()
                );
            }
            // 输出打印前五名玩家的信息。
            System.out.println();
            System.out.println("       " + key);
            System.out.println("       Top players");
            scoreList = jedis.zrevrangeWithScores(key, 0, 4);
            for (Tuple item : scoreList) {
                System.out.println(
                        "Player ID:" +
                                item.getElement() +
                                ", Player Score:" +
                                Double.valueOf(item.getScore()).intValue()
                );
            }
            // 输出打印特定玩家列表。
            System.out.println();
            System.out.println("         " + key);
            System.out.println(" Players with scores from 1,000 to 2,000");
            // 从对应key的SortedSet中获取已经积分在1000至2000的玩家列表。
            scoreList = jedis.zrangeByScoreWithScores(key, 1000, 2000);
            for (Tuple item : scoreList) {
                System.out.println(
                        "Player ID:" +
                                item.getElement() +
                                ", Player Score:" +
                                Double.valueOf(item.getScore()).intValue()
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            jedis.quit();
            jedis.close();
        }
    }
}