/*
 * 本程序提供了一个在PolarDB上进行DML操作的简单Demo
 * This program provides a simple demo to perform DML operation in PolarDB
 *
 * -- 1.首先，你可以在PolarDB的控制台上执行一下操作：
 * -- 1.BEGIN, YOU CAN DO THIS ON PolarDB WEB CONSOLE:
 * CREATE DATABASE sampledb;
 * CREATE ROLE polaruser WITH LOGIN PASSWORD 'password';
 * GRANT ALL PRIVILEGES ON DATABASE sampledb TO polaruser;
 *
 * -- 2. 导入表、数据、函数
 * -- 2.IMPORT TABLES, DATA, FUNCTIONS
 * PGPASSWORD=password psql -hhost -pport -Upolaruser sampledb -fSample.sql
 *
 * -- 3. 修改连接串，运行程序，选择运行模式：RawConnection or EFAndLinq
 * -- 3. Modify connection string, run the program, choose the mode: RawConnection or EFAndLinq
 *
 * -- 4. 务必记得清理该用户
 * -- 4. DO remember to drop the user
 * DROP ROLE polaruser;
 *
 * @revision 1.1
 */

using System;

public class Program
{
    static void Main()
    {
        Console.WriteLine("Select Mode:\n1. RawConnection\n2. EFAndLinq");
        var mode = Console.ReadLine();
        switch (mode)
        {
            case "1":
                RawConnection.Run();
                break;
            case "2":
                EFAndLinq.Run();
                break;
            default:
                Console.WriteLine("Wrong Option");
                break;
        }
        Console.WriteLine("Press enter to continue");
        Console.ReadLine();
    }
}
