//
//  FileTranscriberViewController.m
//  NUIdemo
//
//  Created by zhouguangdong on 2020/8/22.
//  Copyright © 2020 Alibaba idst. All rights reserved.
//

#import <Foundation/Foundation.h>
#define DEBUG_MODE
#import "nuisdk.framework/Headers/NeoNui.h"
#import "FileTranscriberViewController.h"
#import "AppDelegate.h"
#import "NuiSdkUtils.h"

#import <MessageUI/MessageUI.h>
#import <sys/utsname.h>
#import <AdSupport/ASIdentifierManager.h>
//#include <thread>
#include <sys/time.h>
#include <time.h>

#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

static FileTranscriberViewController *myself = nil;

static bool save_wav = false;
static bool save_log = false;

@interface FileTranscriberViewController ()<NeoNuiSdkDelegate>  {
    IBOutlet UIButton *StartButton;
    IBOutlet UIButton *StopButton;

    IBOutlet UITextView *textViewKws;
    IBOutlet UITextView *textViewAsr;
    IBOutlet UITextView *textViewDialog;

    IBOutlet UISwitch *switchLog;

    IBOutlet UITextField *textfield;
    IBOutlet UITextField *textVersion;
    
    IBOutlet UILabel *SaveWavLabel;
}
@property(nonatomic,strong) NeoNui* nui;
@property(nonatomic,strong) NuiSdkUtils *utils;
@property(nonatomic,strong) NSMutableArray *task_list;

- (IBAction)showStart;
- (IBAction)showStop;
@end

@implementation FileTranscriberViewController

#pragma mark - View Callback Action
- (void)viewDidLoad {
    [super viewDidLoad];
    TLog(@"DialogViewController did load");
    myself = self;
    
    [self InitView];

    _utils = [NuiSdkUtils alloc];

    _task_list=[[NSMutableArray alloc]init];

    [self initNui];
    NSString *version = [NSString stringWithUTF8String:[_nui nui_get_version]];
    myself->textVersion.text = version;
}

-(void)viewWillDisappear:(BOOL)animated {
    TLog(@"viewWillDisappear");
    [_nui nui_release];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

#pragma mark - UI action
- (IBAction)StartButHandler:(UIButton *)sender{
    TLog(@"click START BUTTON");
    [myself showStart];
}

- (IBAction)StopButHandler:(id)sender {
    TLog(@"click STOP BUTTON");
    [myself showStop];
}

-(IBAction)showStart {
    dispatch_async(dispatch_get_main_queue(), ^{
        // UI更新代码
        [myself->StartButton setEnabled:NO];
        [myself->StartButton setAlpha:0.4];
        [myself->StopButton setEnabled:YES];
        [myself->StopButton setAlpha:1.0];
        int max_tasks = 1;
        if (_nui != nil) {
            for (int i=0; i<max_tasks; i++) {
                NSString *params = [self genStartParams];
                char task_id[33] = {0};
                int ret = [_nui nui_file_trans_start:[params UTF8String] taskId:task_id];
                if (ret == SUCCESS) {
                    NSLog(@"start trans task %s", task_id);
                    [_task_list addObject:[NSString stringWithUTF8String:task_id]];
                }
            }
        } else {
            TLog(@"in StartButHandler no nui alloc");
        }
    });
}

-(IBAction)showStop {
    
    if (_nui != nil) {
        NSArray* array = [NSArray arrayWithArray: _task_list];
        for (id task in array) {
            [_nui nui_file_trans_cancel:[task UTF8String]];
            [_task_list removeObject:task];
        }
        
        dispatch_async(dispatch_get_main_queue(), ^{
            // UI更新代码
            [myself->StartButton setEnabled:YES];
            [myself->StartButton setAlpha:1.0];
            [myself->StopButton setEnabled:NO];
            [myself->StopButton setAlpha:0.4];
        });
    } else {
        TLog(@"in StopButHandler no nui alloc");
    }
}

-(IBAction)switchLogAction:(id)sender
{
    UISwitch *switchButton = (UISwitch*)sender;
    BOOL isButtonOn = [switchButton isOn];

    TLog(@"set save wav to %d from %d",
              isButtonOn, save_wav);
    save_wav = isButtonOn;
    save_log = isButtonOn;
    [myself terminateNui];
    usleep(200*1000);
    [myself initNui];
    [myself showStop];
    [myself showStart];
}


- (void)terminateNui {
    TLog(@"terminateNui");
    [_nui nui_release];
}

-(void)dealloc{
    TLog(@"dealloc");
    [_nui nui_release];
}

#pragma mark - Nui Listener
-(void)onFileTransEventCallback:(NuiCallbackEvent)nuiEvent
                asrResult:(const char *)asr_result
                   taskId:(const char *)task_id
                 ifFinish:(bool)finish
                  retCode:(int)code {
    TLog(@"onFileTransEventCallback event %d finish %d task_id %s", nuiEvent, finish, task_id);
    if (nuiEvent == EVENT_FILE_TRANS_CONNECTED) {
        [myself showAsrResult:@"连接成功，正在上传..."];
    } else if (nuiEvent == EVENT_FILE_TRANS_UPLOADED) {
        [myself showAsrResult:@"完成上传，正在转写..."];
    } else if (nuiEvent == EVENT_FILE_TRANS_RESULT) {
        NSString *result = [NSString stringWithUTF8String:asr_result];
        [myself showAsrResult:result];
    } else if (nuiEvent == EVENT_ASR_ERROR) {
        TLog(@"EVENT_ASR_ERROR error[%d]", code);
        NSString *result = [NSString stringWithUTF8String:asr_result];
        [myself showAsrResult:result];
    }
    
    if (finish) {
        [_task_list removeObject:[NSString stringWithUTF8String:task_id]];
        if ([_task_list count] == 0) {
            dispatch_async(dispatch_get_main_queue(), ^{
                // UI更新代码
                [myself->StartButton setEnabled:YES];
                [myself->StartButton setAlpha:1.0];
                [myself->StopButton setEnabled:NO];
                [myself->StopButton setAlpha:0.4];
            });
        }
    }
    
    return;
}


#pragma mark - Private methods

-(void) showAsrResult:(NSString *) result {
    dispatch_async(dispatch_get_main_queue(), ^{
        myself->textViewAsr.text = result;
    });
}

-(NSString*) genInitParams {
    NSString *strResourcesBundle = [[NSBundle mainBundle] pathForResource:@"Resources" ofType:@"bundle"];
    NSString *bundlePath = [[NSBundle bundleWithPath:strResourcesBundle] resourcePath];
    NSString *id_string = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
    NSString *debug_path = [_utils createDir];

    NSMutableDictionary *dictM = [NSMutableDictionary dictionary];
    
    [dictM setObject:bundlePath forKey:@"workspace"];
    [dictM setObject:debug_path forKey:@"debug_path"];
    [dictM setObject:id_string forKey:@"device_id"];
    
    //从阿里云获取appkey和token进行语音服务访问
    [dictM setObject:@"n4apKnXZwL1Q7P2C" forKey:@"app_key"];
    [dictM setObject:@"" forKey:@"token"];
    
    //由于token 24小时过期，可以参考getTicket实现从阿里云服务动态获取
    //[_utils getTicket:dictM];
    
    [dictM setObject:@"https://nls-gateway.cn-shanghai.aliyuncs.com/stream/v1/FlashRecognizer" forKey:@"url"];
    
    NSData *data = [NSJSONSerialization dataWithJSONObject:dictM options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    return jsonStr;
}
-(NSString*) genParams {
    NSMutableDictionary *nls_config = [NSMutableDictionary dictionary];
    NSMutableDictionary *dictM = [NSMutableDictionary dictionary];
    [dictM setObject:nls_config forKey:@"nls_config"];

//    如果有HttpDns则可进行设置
//    [dictM setObject:[_utils getDirectIp] forKey:@"direct_ip"];
    
    NSData *data = [NSJSONSerialization dataWithJSONObject:dictM options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    return jsonStr;
}

-(NSString*) genStartParams {
                NSMutableDictionary *nls_config = [NSMutableDictionary dictionary];
    NSMutableDictionary *dictM = [NSMutableDictionary dictionary];
    NSString *file = [[NSBundle mainBundle] pathForResource:@"thirdparty/test" ofType:@"wav"];
    [dictM setObject:file forKey:@"file_path"];
    [nls_config setObject:@"wav" forKey:@"format"];
    [dictM setObject:nls_config forKey:@"nls_config"];
    
    
    NSData *data = [NSJSONSerialization dataWithJSONObject:dictM options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    NSLog(@"start params %@", jsonStr);
    return jsonStr;
}


- (void) initNui {
    if (_nui == NULL) {
        _nui = [NeoNui get_instance];
        _nui.delegate = self;
    }
    //请注意此处的参数配置，其中账号相关需要在Utils.m getTicket 方法中填入后才可访问服务
    NSString * initParam = [self genInitParams];

    [_nui nui_initialize:[initParam UTF8String] logLevel:LOG_LEVEL_VERBOSE saveLog:save_log];
    NSString * parameters = [self genParams];
    [_nui nui_set_params:[parameters UTF8String]];
}



#pragma mark - View
-(void)InitView {
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.title = @"文件转写";
/*---------------------------------Button---------------------------------------------*/
    //Start Button
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat button_width = global_size.width/SCREEN_WIDTH_BASE * 70;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 30;

    
    CGFloat x = global_size.width/SCREEN_WIDTH_BASE * 27.5;
    CGFloat y = global_size.height/SCREEN_HEIGHT_BASE * 70;
    
    StartButton = [UIButton buttonWithType:UIButtonTypeCustom];
    StartButton.frame = CGRectMake(x, y, button_width, button_height);
    UIImage *image = [UIImage imageNamed:@"button_start"];
    [StartButton setBackgroundImage:image forState:UIControlStateNormal];
    [StartButton setTitle:@"开始" forState:UIControlStateNormal];
    [StartButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    StartButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [StartButton addTarget:self action:@selector(StartButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:StartButton];
    
    //stop Button
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5+90*2);
    y = global_size.height/SCREEN_HEIGHT_BASE * 70;
    
    StopButton = [UIButton buttonWithType:UIButtonTypeCustom];
    StopButton.frame = CGRectMake(x, y, button_width, button_height);
    image = [UIImage imageNamed:@"button_start"];
    [StopButton setBackgroundImage:image forState:UIControlStateNormal];
    [StopButton setTitle:@"结束" forState:UIControlStateNormal];
    [StopButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    StopButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [StopButton addTarget:self action:@selector(StopButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:StopButton];
    
    
/*---------------------------------UITextView---------------------------------------------*/
    //kws text view
    CGFloat kws_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat kws_view_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    y = global_size.height/SCREEN_HEIGHT_BASE * 110;
    
    CGRect textViewContent_rect = CGRectMake(x, y, kws_view_width, kws_view_height);
    if (!textViewKws) {
        textViewKws = [[UITextView alloc] initWithFrame:textViewContent_rect];
    }
    textViewKws.layer.borderWidth = 0.6;
    textViewKws.layer.borderColor = [UIColor blackColor].CGColor;
    textViewKws.layer.cornerRadius = 10;
    [textViewKws setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewKws.scrollEnabled = YES;
    
    textViewKws.textColor = [UIColor darkGrayColor];
    textViewKws.font = [UIFont systemFontOfSize:10];
//    [self.view addSubview:textViewKws];
    
    //wakeup text view
    CGFloat asr_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat asr_view_height = global_size.height/SCREEN_HEIGHT_BASE * 60;
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    y = global_size.height/SCREEN_HEIGHT_BASE * 110 + kws_view_height + 10;
    
    CGRect asr_rect = CGRectMake(x, y, asr_view_width, asr_view_height);
    if (!textViewAsr) {
        textViewAsr = [[UITextView alloc] initWithFrame:asr_rect];
    }
    textViewAsr.layer.borderWidth = 0.6;
    textViewAsr.layer.borderColor = [UIColor blackColor].CGColor;
    textViewAsr.layer.cornerRadius = 10;
    [textViewAsr setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewAsr.scrollEnabled = YES;
    
    textViewAsr.textColor = [UIColor darkGrayColor];
    textViewAsr.font = [UIFont systemFontOfSize:10];
    [self.view addSubview:textViewAsr];
    
    //dialog text view
    CGFloat dialog_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat dialog_view_height = global_size.height/SCREEN_HEIGHT_BASE * 120;
    CGFloat dialog_x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    CGFloat dialog_y = global_size.height/SCREEN_HEIGHT_BASE * 110 + kws_view_height + 10 + asr_view_height + 10;
    
    CGRect dialog_rect = CGRectMake(dialog_x, dialog_y, dialog_view_width, dialog_view_height);
    if (!textViewDialog) {
        textViewDialog = [[UITextView alloc] initWithFrame:dialog_rect];
    }
    textViewDialog.layer.borderWidth = 0.6;
    textViewDialog.layer.borderColor = [UIColor blackColor].CGColor;
    textViewDialog.layer.cornerRadius = 10;
    [textViewDialog setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewDialog.scrollEnabled = YES;
    
    textViewDialog.textColor = [UIColor darkGrayColor];
    textViewDialog.font = [UIFont systemFontOfSize:10];
//    [self.view addSubview:textViewDialog];
    
    /*---------------------------------Switch---------------------------------------------*/
    
    CGFloat switch_width = global_size.width/SCREEN_WIDTH_BASE * 80;
    CGFloat switch_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    CGFloat label_width = global_size.width/SCREEN_WIDTH_BASE * 80;
    CGFloat label_height = global_size.height/SCREEN_HEIGHT_BASE * 30;

    //switch save wav
    CGFloat save_wav_label_x = dialog_x;
    CGFloat save_wav_label_y = dialog_y + dialog_view_height + label_height;

    CGRect save_wav_label_rect = CGRectMake(save_wav_label_x, save_wav_label_y, label_width, label_height);
    if (!SaveWavLabel) {
        SaveWavLabel = [[UILabel alloc] initWithFrame:save_wav_label_rect];
    }
    SaveWavLabel.text = @"音频保存";
//    [self.view addSubview:SaveWavLabel];

    CGFloat save_wav_switch_x = save_wav_label_x + label_width;
    CGFloat save_wav_switch_y = save_wav_label_y;
    CGRect save_wav_switch_rect = CGRectMake(save_wav_switch_x, save_wav_switch_y, switch_width, switch_height);
    switchLog = [[UISwitch alloc] initWithFrame:save_wav_switch_rect];
    [switchLog addTarget:self action:@selector(switchLogAction:) forControlEvents:UIControlEventTouchUpInside];
//    [self.view addSubview:switchLog];
    
    /*---------------------------------------TextField----------------------------------*/
    
    CGFloat text_field_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat text_field_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    //text field
    CGFloat text_field_x = save_wav_label_x;
    CGFloat text_field_y = save_wav_switch_y + label_height + label_height;
    
    CGRect text_field_rect = CGRectMake(text_field_x, text_field_y, text_field_width, text_field_height);
    textfield = [[UITextField alloc] initWithFrame:text_field_rect];
    textfield.layer.borderWidth = 0.6;
    textfield.layer.borderColor = [UIColor blackColor].CGColor;
    textfield.layer.cornerRadius = 10;
    [textfield setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    
    textfield.textColor = [UIColor darkGrayColor];
    textfield.font = [UIFont systemFontOfSize:15];
//    [self.view addSubview:textfield];
    
    //text sdk version
    CGFloat text_version_x = text_field_x;
    CGFloat text_version_y = text_field_y + text_field_height + 2;
    
    CGRect text_version_rect = CGRectMake(text_version_x, text_version_y, text_field_width, text_field_height);
    textVersion = [[UITextField alloc] initWithFrame:text_version_rect];

    textVersion.layer.borderWidth = 0.6;
    textVersion.layer.borderColor = [UIColor blackColor].CGColor;
    textVersion.layer.cornerRadius = 10;
    [textVersion setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    
    textVersion.textColor = [UIColor darkGrayColor];
    textVersion.font = [UIFont systemFontOfSize:15];
    [self.view addSubview:textVersion];
    
    
    [myself->StartButton setEnabled:YES];
    [myself->StartButton setAlpha:1.0];
    [myself->StopButton setEnabled:NO];
    [myself->StopButton setAlpha:0.4];
    
    textViewKws.scrollEnabled = YES;
    textViewAsr.scrollEnabled = YES;
    textViewDialog.scrollEnabled = YES;
    
    textViewKws.editable = NO;
    textViewAsr.editable = NO;
    textViewDialog.editable = NO;
    
    myself->textVersion.minimumFontSize = 10;
    myself->textfield.minimumFontSize = 10;
}


@end
