//
//  LocalSpeechRecognizerViewController.m
//  NUIdemo
//
//  Created by zhouguangdong on 2020/9/6.
//  Copyright © 2020 Alibaba idst. All rights reserved.
//

#import <Foundation/Foundation.h>
#define DEBUG_MODE
#import "nuisdk.framework/Headers/NeoNui.h"
#import "LocalSpeechRecognizerViewController.h"
#import "AppDelegate.h"
#import "NuiSdkUtils.h"

#import "audio/NlsVoiceRecorder.h"
#import <AudioToolbox/AudioToolbox.h>
#import <MessageUI/MessageUI.h>
#import <sys/utsname.h>
#import <AdSupport/ASIdentifierManager.h>
//#include <thread>
#include <sys/time.h>
#include <time.h>

#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

static LocalSpeechRecognizerViewController *myself = nil;

static BOOL save_wav = NO;
static BOOL save_log = NO;

@interface LocalSpeechRecognizerViewController ()<NlsVoiceRecorderDelegate, NeoNuiSdkDelegate> {
    IBOutlet UIButton *StartButton;
    IBOutlet UIButton *StopButton;

    IBOutlet UITextView *textViewKws;
    IBOutlet UITextView *textViewAsr;
    IBOutlet UITextView *textViewDialog;

    IBOutlet UISwitch *switchLog;

    IBOutlet UITextField *textfield;
    IBOutlet UITextField *textVersion;
    
    IBOutlet UILabel *SaveWavLabel;
}
@property(nonatomic,strong) NeoNui* nui;
@property(nonatomic,strong) NlsVoiceRecorder *voiceRecorder;
@property(nonatomic,strong) NSMutableData *recordedVoiceData;
@property(nonatomic,strong) NuiSdkUtils *utils;
@property(nonatomic) NSInteger callNum;

- (IBAction)showStart;
- (IBAction)showStop;
@end

@implementation LocalSpeechRecognizerViewController

#pragma mark - View Callback Action
- (void)viewDidLoad {
    [super viewDidLoad];
    TLog(@"DialogViewController did load");
    myself = self;
    
    [self InitView];
    
    _voiceRecorder = [[NlsVoiceRecorder alloc] init];
    _voiceRecorder.delegate = self;

    _utils = [NuiSdkUtils alloc];
    _callNum = 0;

    [self initNui];
    NSString *version = [NSString stringWithUTF8String:[_nui nui_get_version]];
    myself->textVersion.text = version;
}

-(void)viewWillDisappear:(BOOL)animated {
    TLog(@"viewWillDisappear");
    [_nui nui_release];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

#pragma mark - UI action
- (IBAction)StartButHandler:(UIButton *)sender{
    TLog(@"click START BUTTON, start recorder!");
    [myself showStart];
    TLog(@"started");
}

- (IBAction)StopButHandler:(id)sender {
    TLog(@"click STOP BUTTON, stop recorder!");
    [myself showStop];
}

-(IBAction)showStart {
    dispatch_async(dispatch_get_main_queue(), ^{
        // UI更新代码
        [myself->StartButton setEnabled:NO];
        [myself->StartButton setAlpha:0.4];
        [myself->StopButton setEnabled:YES];
        [myself->StopButton setAlpha:1.0];
        
        [myself showKwsResult:@""];

        if (_nui != nil) {
            [_nui nui_dialog_start:MODE_P2T dialogParam:NULL];
//            usleep(5000000);
            TLog(@"dialog start");
        } else {
            TLog(@"in StartButHandler no nui alloc");
        }
    });
    TLog(@"dialog started");
}

-(IBAction)showStop {
    self.recordedVoiceData = nil;
    
    if (_nui != nil) {
        [_nui nui_dialog_cancel:NO];
        [_voiceRecorder stop:YES];
        dispatch_async(dispatch_get_main_queue(), ^{
            // UI更新代码
            [myself->StartButton setEnabled:YES];
            [myself->StartButton setAlpha:1.0];
            [myself->StopButton setEnabled:NO];
            [myself->StopButton setAlpha:0.4];
        });
    } else {
        TLog(@"in StopButHandler no nui alloc");
    }
}

-(IBAction)switchLogAction:(id)sender
{
    UISwitch *switchButton = (UISwitch*)sender;
    BOOL isButtonOn = [switchButton isOn];

    TLog(@"set save wav to %d from %d",
              isButtonOn, save_wav);
    save_wav = isButtonOn;
    save_log = isButtonOn;
    [myself terminateNui];
    usleep(200*1000);
    [myself initNui];
    [myself showStop];
    [myself showStart];
}


- (void)terminateNui {
    TLog(@"%s",__FUNCTION__);
    [_nui nui_release];
}

-(void)dealloc{
    TLog(@"%s",__FUNCTION__);
    [_nui nui_release];
}

#pragma mark - Voice Recorder Delegate
-(void) recorderDidStart{
    TLog(@"recorderDidStart");
}

-(void) recorderDidStop{
    [self.recordedVoiceData setLength:0];
    TLog(@"recorderDidStop");
}

-(void) voiceRecorded:(NSData*) frame{
#ifdef PUSH_AUDIO_TO_NUI
    if (audio_state == kAudioStateOpen) {
        int len = [frame length];
        char *audioData = new char[len];
        [frame getBytes:audioData length:len];
        [_nui nui_update_audio_data:audioData Len:len FirstPack:NO];
        delete [] audioData;
        new_record_data_pack = false;
    }
#else
    @synchronized(_recordedVoiceData){
        [_recordedVoiceData appendData:frame];
    }
#endif
}

-(void) voiceDidFail:(NSError*)error{
    TLog(@"recorder error ");
}

#pragma mark - Nui Listener
-(void)onNuiEventCallback:(NuiCallbackEvent)nuiEvent
                   dialog:(long)dialog
                kwsResult:(const char *)wuw
                asrResult:(const char *)asr_result
                 ifFinish:(BOOL)finish
                  retCode:(int)code {
    TLog(@"onNuiEventCallback event %d finish %d", nuiEvent, finish);
    if (nuiEvent == EVENT_ASR_PARTIAL_RESULT || nuiEvent == EVENT_ASR_RESULT) {
        TLog(@"ASR RESULT %s finish %d", asr_result, finish);
        NSString *result = [NSString stringWithUTF8String:asr_result];
        [myself showAsrResult:result];
    } else if (nuiEvent == EVENT_ASR_ERROR) {
        TLog(@"EVENT_ASR_ERROR error[%d]", code);
    } else if (nuiEvent == EVENT_MIC_ERROR) {
        TLog(@"MIC ERROR");
        [_voiceRecorder stop:YES];
        [_voiceRecorder start];
    }
    
    if (finish) {
        dispatch_async(dispatch_get_main_queue(), ^{
            // UI更新代码
            [myself->StartButton setEnabled:YES];
            [myself->StartButton setAlpha:1.0];
            [myself->StopButton setEnabled:NO];
            [myself->StopButton setAlpha:0.4];
        });
    }
    
    return;
}

-(int)onNuiNeedAudioData:(char *)audioData length:(int)len {
    static int emptyCount = 0;
    @autoreleasepool {
        @synchronized(_recordedVoiceData){
            if (_recordedVoiceData.length > 0) {
                int recorder_len = 0;
                if (_recordedVoiceData.length > len)
                    recorder_len = len;
                else
                    recorder_len = _recordedVoiceData.length;
                NSData *tempData = [_recordedVoiceData subdataWithRange:NSMakeRange(0, recorder_len)];
                [tempData getBytes:audioData length:recorder_len];
                tempData = nil;
                NSInteger remainLength = _recordedVoiceData.length - recorder_len;
                NSRange range = NSMakeRange(recorder_len, remainLength);
                [_recordedVoiceData setData:[_recordedVoiceData subdataWithRange:range]];
                emptyCount = 0;
                return recorder_len;
            } else {
                if (emptyCount++ >= 50) {
                    TLog(@"_recordedVoiceData length = %lu! empty 50times.", (unsigned long)_recordedVoiceData.length);
                    emptyCount = 0;
                }
                return 0;
            }

        }
    }
    return 0;
}

-(void)onNuiAudioStateChanged:(NuiAudioState)state{
    TLog(@"onNuiAudioStateChanged state=%u", state);
    if (state == STATE_CLOSE || state == STATE_PAUSE) {
        [_voiceRecorder stop:YES];
    } else if (state == STATE_OPEN){
        self.recordedVoiceData = [NSMutableData data];
        [_voiceRecorder start];
    }
}

#pragma mark - Private methods

-(void) showKwsResult:(NSString *) result {
    dispatch_async(dispatch_get_main_queue(), ^{
        myself->textViewKws.text = result;
    });
}

-(void) showAsrResult:(NSString *) result {
    dispatch_async(dispatch_get_main_queue(), ^{
        myself->textViewAsr.text = result;
    });
}

-(void) showDialogResult:(NSString *) result {
    dispatch_async(dispatch_get_main_queue(), ^{
        myself->textViewDialog.text = result;
    });
}

-(NSString*) genInitParams {
    NSString *strResourcesBundle = [[NSBundle mainBundle] pathForResource:@"Resources" ofType:@"bundle"];
    NSString *bundlePath = [[NSBundle bundleWithPath:strResourcesBundle] resourcePath];
    NSString *id_string = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
    NSString *debug_path = [_utils createDir];

    NSMutableDictionary *dictM = [NSMutableDictionary dictionary];
    
    [dictM setObject:bundlePath forKey:@"workspace"];
    [dictM setObject:debug_path forKey:@"debug_path"];
    [dictM setObject:id_string forKey:@"device_id"];
    [dictM setObject:save_wav ? @"true" : @"false" forKey:@"save_wav"];
#ifdef PUSH_AUDIO_TO_NUI
    [dictM setObject:@"true" forKey:@"audio_update_manually"];
#endif
    //2 for locol asr
    [dictM setObject:@"2" forKey:@"service_mode"];
    //从阿里云获取appkey和token进行语音服务访问
//    [dictM setObject:@"n4apKnXZwL1Q7P2C" forKey:@"app_key"];
//    [dictM setObject:@"bba217d02c614390a4b60ec61d10950d" forKey:@"token"];
    [dictM setObject:@"" forKey:@"ak_id"];
    [dictM setObject:@"" forKey:@"ak_secret"];
    [dictM setObject:@"nui_sdk_inc" forKey:@"sdk_code"];
    [dictM setObject:@"" forKey:@"app_key"];

    //由于token 24小时过期，可以参考getTicket实现从阿里云服务动态获取
    //[_utils getTicket:dictM];
    [dictM setObject:@"wss://nls-gateway.cn-shanghai.aliyuncs.com:443/ws/v1" forKey:@"url"];
    
    NSData *data = [NSJSONSerialization dataWithJSONObject:dictM options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    return jsonStr;
}
-(NSString*) genParams {
    NSMutableDictionary *dictM = [NSMutableDictionary dictionary];
    [dictM setValue:@(SERVICE_TYPE_SPEECH_TRANSCRIBER) forKey:@"service_type"];
    
    NSData *data = [NSJSONSerialization dataWithJSONObject:dictM options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    return jsonStr;
}

static void AsyncCb(void *user_data, int result, const char* ex_info) {
    NSLog(@"async cb result %d", result);
}

- (void) initNui {
    if (_nui == NULL) {
        _nui = [NeoNui get_instance];
        _nui.delegate = self;
    }
    //请注意此处的参数配置，其中账号相关需要在Utils.m getTicket 方法中填入后才可访问服务
    NSString * initParam = [self genInitParams];

    [_nui nui_initialize:[initParam UTF8String] logLevel:LOG_LEVEL_VERBOSE saveLog:save_log];
    NSString * parameters = [self genParams];
    [_nui nui_set_params:[parameters UTF8String]];
}

#pragma mark - View
-(void)InitView {
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.title = @"本地一句话识别";
/*---------------------------------Button---------------------------------------------*/
    //Start Button
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat button_width = global_size.width/SCREEN_WIDTH_BASE * 70;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 30;

    
    CGFloat x = global_size.width/SCREEN_WIDTH_BASE * 27.5;
    CGFloat y = global_size.height/SCREEN_HEIGHT_BASE * 70;
    
    StartButton = [UIButton buttonWithType:UIButtonTypeCustom];
    StartButton.frame = CGRectMake(x, y, button_width, button_height);
    UIImage *image = [UIImage imageNamed:@"button_start"];
    [StartButton setBackgroundImage:image forState:UIControlStateNormal];
    [StartButton setTitle:@"开始" forState:UIControlStateNormal];
    [StartButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    StartButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [StartButton addTarget:self action:@selector(StartButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:StartButton];
    
    //stop Button
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5+90*2);
    y = global_size.height/SCREEN_HEIGHT_BASE * 70;
    
    StopButton = [UIButton buttonWithType:UIButtonTypeCustom];
    StopButton.frame = CGRectMake(x, y, button_width, button_height);
    image = [UIImage imageNamed:@"button_start"];
    [StopButton setBackgroundImage:image forState:UIControlStateNormal];
    [StopButton setTitle:@"结束" forState:UIControlStateNormal];
    [StopButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    StopButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [StopButton addTarget:self action:@selector(StopButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:StopButton];
    
    
/*---------------------------------UITextView---------------------------------------------*/
    //kws text view
    CGFloat kws_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat kws_view_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    y = global_size.height/SCREEN_HEIGHT_BASE * 110;
    
    CGRect textViewContent_rect = CGRectMake(x, y, kws_view_width, kws_view_height);
    if (!textViewKws) {
        textViewKws = [[UITextView alloc] initWithFrame:textViewContent_rect];
    }
    textViewKws.layer.borderWidth = 0.6;
    textViewKws.layer.borderColor = [UIColor blackColor].CGColor;
    textViewKws.layer.cornerRadius = 10;
    [textViewKws setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewKws.scrollEnabled = YES;
    
    textViewKws.textColor = [UIColor darkGrayColor];
    textViewKws.font = [UIFont systemFontOfSize:10];
    [self.view addSubview:textViewKws];
    
    //wakeup text view
    CGFloat asr_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat asr_view_height = global_size.height/SCREEN_HEIGHT_BASE * 60;
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    y = global_size.height/SCREEN_HEIGHT_BASE * 110 + kws_view_height + 10;
    
    CGRect asr_rect = CGRectMake(x, y, asr_view_width, asr_view_height);
    if (!textViewAsr) {
        textViewAsr = [[UITextView alloc] initWithFrame:asr_rect];
    }
    textViewAsr.layer.borderWidth = 0.6;
    textViewAsr.layer.borderColor = [UIColor blackColor].CGColor;
    textViewAsr.layer.cornerRadius = 10;
    [textViewAsr setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewAsr.scrollEnabled = YES;
    
    textViewAsr.textColor = [UIColor darkGrayColor];
    textViewAsr.font = [UIFont systemFontOfSize:10];
    [self.view addSubview:textViewAsr];
    
    //dialog text view
    CGFloat dialog_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat dialog_view_height = global_size.height/SCREEN_HEIGHT_BASE * 120;
    CGFloat dialog_x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    CGFloat dialog_y = global_size.height/SCREEN_HEIGHT_BASE * 110 + kws_view_height + 10 + asr_view_height + 10;
    
    CGRect dialog_rect = CGRectMake(dialog_x, dialog_y, dialog_view_width, dialog_view_height);
    if (!textViewDialog) {
        textViewDialog = [[UITextView alloc] initWithFrame:dialog_rect];
    }
    textViewDialog.layer.borderWidth = 0.6;
    textViewDialog.layer.borderColor = [UIColor blackColor].CGColor;
    textViewDialog.layer.cornerRadius = 10;
    [textViewDialog setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewDialog.scrollEnabled = YES;
    
    textViewDialog.textColor = [UIColor darkGrayColor];
    textViewDialog.font = [UIFont systemFontOfSize:10];
    [self.view addSubview:textViewDialog];
    
    /*---------------------------------Switch---------------------------------------------*/
    
    CGFloat switch_width = global_size.width/SCREEN_WIDTH_BASE * 80;
    CGFloat switch_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    CGFloat label_width = global_size.width/SCREEN_WIDTH_BASE * 80;
    CGFloat label_height = global_size.height/SCREEN_HEIGHT_BASE * 30;

    //switch save wav
    CGFloat save_wav_label_x = dialog_x;
    CGFloat save_wav_label_y = dialog_y + dialog_view_height + label_height;

    CGRect save_wav_label_rect = CGRectMake(save_wav_label_x, save_wav_label_y, label_width, label_height);
    if (!SaveWavLabel) {
        SaveWavLabel = [[UILabel alloc] initWithFrame:save_wav_label_rect];
    }
    SaveWavLabel.text = @"音频保存";
    [self.view addSubview:SaveWavLabel];

    CGFloat save_wav_switch_x = save_wav_label_x + label_width;
    CGFloat save_wav_switch_y = save_wav_label_y;
    CGRect save_wav_switch_rect = CGRectMake(save_wav_switch_x, save_wav_switch_y, switch_width, switch_height);
    switchLog = [[UISwitch alloc] initWithFrame:save_wav_switch_rect];
    [switchLog addTarget:self action:@selector(switchLogAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:switchLog];
    
    /*---------------------------------------TextField----------------------------------*/
    
    CGFloat text_field_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat text_field_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    //text field
    CGFloat text_field_x = save_wav_label_x;
    CGFloat text_field_y = save_wav_switch_y + label_height + label_height;
    
    CGRect text_field_rect = CGRectMake(text_field_x, text_field_y, text_field_width, text_field_height);
    textfield = [[UITextField alloc] initWithFrame:text_field_rect];
    textfield.layer.borderWidth = 0.6;
    textfield.layer.borderColor = [UIColor blackColor].CGColor;
    textfield.layer.cornerRadius = 10;
    [textfield setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    
    textfield.textColor = [UIColor darkGrayColor];
    textfield.font = [UIFont systemFontOfSize:15];
    [self.view addSubview:textfield];
    
    //text sdk version
    CGFloat text_version_x = text_field_x;
    CGFloat text_version_y = text_field_y + text_field_height + 2;
    
    CGRect text_version_rect = CGRectMake(text_version_x, text_version_y, text_field_width, text_field_height);
    textVersion = [[UITextField alloc] initWithFrame:text_version_rect];

    textVersion.layer.borderWidth = 0.6;
    textVersion.layer.borderColor = [UIColor blackColor].CGColor;
    textVersion.layer.cornerRadius = 10;
    [textVersion setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    
    textVersion.textColor = [UIColor darkGrayColor];
    textVersion.font = [UIFont systemFontOfSize:15];
    [self.view addSubview:textVersion];
    
    
    [myself->StartButton setEnabled:YES];
    [myself->StartButton setAlpha:1.0];
    [myself->StopButton setEnabled:NO];
    [myself->StopButton setAlpha:0.4];
    
    textViewKws.scrollEnabled = YES;
    textViewAsr.scrollEnabled = YES;
    textViewDialog.scrollEnabled = YES;
    
    textViewKws.editable = NO;
    textViewAsr.editable = NO;
    textViewDialog.editable = NO;
    
    myself->textVersion.minimumFontSize = 10;
    myself->textfield.minimumFontSize = 10;
}


@end
