#import "RootTableViewController.h"
#import "TTSViewController.h"
#import "LocalTTSViewController.h"
#import "SpeechRecognizerViewController.h"
#import "WakeupAndSpeechRecognizerViewController.h"
#import "SpeechTranscriberViewController.h"
#import "FileTranscriberViewController.h"
#import "LocalSpeechRecognizerViewController.h"
#import "NuiCfg.h"

@interface RootTableViewController () {
    IBOutlet UIButton *ASRButtion;
   IBOutlet UIButton *PlayButton;
   IBOutlet UIButton *TestButton;
   IBOutlet UIButton *MonkeyButton;
}

@end

@implementation RootTableViewController
#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

-(void) setupButton:(UIButton*)button
                    index:(int)index
                    title:(NSString*)title
                    action:(SEL)action {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat button_width = global_size.width;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 40;
    
    
    CGFloat button_x = 0;
    CGFloat button_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;

    button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(button_x, button_y, button_width, button_height);
    UIImage *button_image = [UIImage imageNamed:@"button_start"];
    [button setBackgroundImage:button_image forState:UIControlStateNormal];
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    button.titleLabel.font = [UIFont systemFontOfSize:18];
    [button addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:button];
}

-(void) viewDidLoad {
    [super viewDidLoad];
    NSLog(@"tableView enter self.navigationController %@", self.navigationController);
    
    int idx = 1;
#ifdef SDK_NUI
    [self setupButton:ASRButtion index:idx++ title:@"一句话识别" action:@selector(startSpeechRecognizer:)];
    [self setupButton:ASRButtion index:idx++ title:@"实时转写" action:@selector(startSpeechTranscriber:)];
    [self setupButton:ASRButtion index:idx++ title:@"唤醒识别(暂不对外开发)" action:@selector(startWakeupAndSpeechRecognizer:)];
#endif
#ifdef SDK_TTS
    [self setupButton:ASRButtion index:idx++ title:@"语音合成" action:@selector(startTts:)];
    [self setupButton:ASRButtion index:idx++ title:@"本地语音合成" action:@selector(startLocalTts:)];
#endif
#ifdef SDK_FILE_TRANS
    [self setupButton:ASRButtion index:idx++ title:@"文件转写" action:@selector(startFileTranscriber:)];
#endif
    
#ifdef SDK_LOCAL_ASR
    [self setupButton:ASRButtion index:idx++ title:@"本地一句话识别(暂不对外开发)" action:@selector(startLocalSpeechRecognizer:)];
#endif
//    [self setupButton:ASRButtion index:4 title:@"唤醒识别对话" action:@selector(startDialog:)];
//    [self setupButton:ASRButtion index:4 title:@"Monkey测试" action:@selector(startMonkey:)];
}

- (IBAction)startSpeechRecognizer:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[SpeechRecognizerViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startSpeechTranscriber:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[SpeechTranscriberViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startFileTranscriber:(UIButton *)sender {
#ifdef SDK_FILE_TRANS
    UIViewController * controller = nil;
    controller = [[FileTranscriberViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}


- (IBAction)startTts:(UIButton *)sender {
#ifdef SDK_TTS
    UIViewController * controller = nil;
    controller = [[TTSViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}
- (IBAction)startLocalTts:(UIButton *)sender {
#ifdef SDK_TTS
    UIViewController * controller = nil;
    controller = [[LocalTTSViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startWakeupAndSpeechRecognizer:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[WakeupAndSpeechRecognizerViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startLocalSpeechRecognizer:(UIButton *)sender {
#ifdef SDK_LOCAL_ASR
    UIViewController * controller = nil;
    controller = [[LocalSpeechRecognizerViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

//- (IBAction)startMonkey:(UIButton *)sender {
//    UIViewController * controller = nil;
//    controller = [[MonkeyViewController alloc] init];
//    [self.navigationController pushViewController:controller animated:YES];
//}
@end
