/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.springcloud;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.exception.TxcErrCode;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

@WebFilter(filterName="trxContextFilter", urlPatterns={"/*"})
public class AFilter
implements Filter {
    private static final LoggerWrap LOGGER = LoggerInit.logger;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            String xid = TxcContext.getCurrentXid();
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String rpcXid = request.getHeader("TXC_XID");
            String beginCountStr = request.getHeader("BEGIN_COUNT");
            String commitCountStr = request.getHeader("COMMIT_COUNT");
            int beginCount = 0;
            int commitCount = 0;
            if (!StringUtils.isEmpty((Object)beginCountStr)) {
                beginCount = Integer.parseInt(beginCountStr);
            }
            if (!StringUtils.isEmpty((Object)commitCountStr)) {
                commitCount = Integer.parseInt(commitCountStr);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("xid in TxcContext {} xid in TxcContext {}", new Object[]{xid, rpcXid});
            }
            if (xid == null && rpcXid != null) {
                TxcContext.bind((String)rpcXid, null);
                TxcContext.setBegin((int)beginCount);
                TxcContext.setCommitCount((int)commitCount);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("bind {} to TxcContext", new Object[]{rpcXid});
                }
            }
        }
        catch (Throwable exx) {
            LOGGER.error(TxcErrCode.UnknownAppError, exx);
        }
        filterChain.doFilter(servletRequest, servletResponse);
        String unbindXid = TxcContext.getCurrentXid();
        String rpcXid = ((HttpServletRequest)servletRequest).getHeader("TXC_XID");
        if (!StringUtils.isEmpty((Object)unbindXid)) {
            if (!unbindXid.equals(rpcXid)) {
                LOGGER.error("Unknown", "xid has changed, please check!");
                return;
            }
            TxcContext.unbind();
            TxcContext.clearReenterCounter();
        }
    }

    public void destroy() {
    }
}

