/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.springcloud;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.util.StringUtils;

public class FeignRequestInterceptor
implements RequestInterceptor {
    private static final LoggerWrap LOGGER = LoggerInit.logger;

    public void apply(RequestTemplate template) {
        String xid = TxcContext.getCurrentXid();
        int beginCount = TxcContext.getBeginCount();
        int commitCount = TxcContext.getCommitCount();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("xid: " + xid + " beginCount: " + beginCount + " commitCount: " + commitCount);
        }
        if (!StringUtils.isEmpty((Object)xid)) {
            template.header("TXC_XID", new String[]{xid});
            template.header("BEGIN_COUNT", new String[]{String.valueOf(beginCount)});
            template.header("COMMIT_COUNT", new String[]{String.valueOf(commitCount)});
        }
    }
}

