/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.springcloud;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.util.StringUtils;

public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final LoggerWrap LOGGER = LoggerInit.logger;

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        HttpRequestWrapper requestWrapper = new HttpRequestWrapper(httpRequest);
        String xid = TxcContext.getCurrentXid();
        int beginCount = TxcContext.getBeginCount();
        int commitCount = TxcContext.getCommitCount();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("xid: " + xid + " beginCount: " + beginCount + " commitCount: " + commitCount);
        }
        if (!StringUtils.isEmpty((Object)xid)) {
            requestWrapper.getHeaders().add("TXC_XID", xid);
            requestWrapper.getHeaders().add("BEGIN_COUNT", String.valueOf(beginCount));
            requestWrapper.getHeaders().add("COMMIT_COUNT", String.valueOf(commitCount));
        }
        return clientHttpRequestExecution.execute((HttpRequest)requestWrapper, bytes);
    }
}

