/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.client.springcloud;

import com.taobao.txc.client.aop.TxcTransactionScaner;
import com.taobao.txc.client.springcloud.TxcProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TxcProperties.class})
public class TransactionAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final TxcProperties txcProperties;

    public TransactionAutoConfiguration(ApplicationContext applicationContext, TxcProperties txcProperties) {
        this.applicationContext = applicationContext;
        this.txcProperties = txcProperties;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.cloud.txc", name={"txcServerGroup"})
    public TxcTransactionScaner globalTransactionScanner() {
        String appName = this.txcProperties.getTxcAppName() == null ? this.applicationContext.getEnvironment().getProperty("spring.application.name") : this.txcProperties.getTxcAppName();
        String txServiceGroup = this.txcProperties.getTxcServerGroup();
        int mode = this.txcProperties.getMode() == 0 ? 1 : this.txcProperties.getMode();
        TxcTransactionScaner txcTransactionScanner = new TxcTransactionScaner(appName, txServiceGroup, mode, this.txcProperties.getUrl());
        if (!TransactionAutoConfiguration.isEmpty(this.txcProperties.getAccessKey())) {
            txcTransactionScanner.setAccessKey(this.txcProperties.getAccessKey());
        }
        if (!TransactionAutoConfiguration.isEmpty(this.txcProperties.getSecretKey())) {
            txcTransactionScanner.setSecretKey(this.txcProperties.getSecretKey());
        }
        return txcTransactionScanner;
    }
}

